package org.bidib.wizard.camel.config;

import org.apache.camel.CamelContext;
import org.apache.camel.impl.DefaultCamelContext;
import org.bidib.wizard.api.model.connection.BidibConnection;
import org.bidib.wizard.camel.stream.BidibMessageStreamFactory;
import org.bidib.wizard.camel.stream.BidibMessageStreamFunction;
import org.bidib.wizard.camel.stream.processor.BidibMessageProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
public class MessageStreamConfig {

    private static final Logger LOGGER = LoggerFactory.getLogger(MessageStreamConfig.class);

    @Bean
    public BidibMessageStreamFactory bidibMessageStreamFactory() {
        BidibMessageStreamFactory factory = new BidibMessageStreamFactory() {

            @Override
            public BidibMessageStreamFunction createMessageStream(final BidibConnection connection) {
                BidibMessageStreamFunction bidibMessageStreamFunction = bidibMessageStreamFunction(connection);
                LOGGER.info("Created new bidibMessageStreamFunction:{}", bidibMessageStreamFunction);
                return bidibMessageStreamFunction;
            }

        };
        return factory;
    }

    @Bean
    @Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
    public BidibMessageStreamFunction bidibMessageStreamFunction(final BidibConnection connection) {

        BidibMessageStreamFunction bidibMessageStreamFunction =
            new BidibMessageStreamFunction(camelContext(), connection.getConnectionId(),
                connection.getSubjectMessages());

        return bidibMessageStreamFunction;
    }

    @Bean
    public CamelContext camelContext() {
        // create the camel context
        CamelContext camelContext = new DefaultCamelContext();
        return camelContext;
    }

    @Bean
    public BidibMessageProcessor bidibMessageProcessor() {
        return new BidibMessageProcessor();
    }
}
