/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.camel.config;

import io.reactivex.rxjava3.subjects.Subject;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.DefaultCamelContext;
import org.bidib.wizard.api.model.connection.AbstractMessageEvent;
import org.bidib.wizard.api.model.connection.BidibConnection;
import org.bidib.wizard.camel.stream.BidibMessageStreamFactory;
import org.bidib.wizard.camel.stream.BidibMessageStreamFunction;
import org.bidib.wizard.camel.stream.processor.BidibMessageProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
public class MessageStreamConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageStreamConfig.class);

    @Bean
    public BidibMessageStreamFactory bidibMessageStreamFactory() {
        BidibMessageStreamFactory factory = new BidibMessageStreamFactory(){

            @Override
            public BidibMessageStreamFunction createMessageStream(BidibConnection connection) {
                BidibMessageStreamFunction bidibMessageStreamFunction = MessageStreamConfig.this.bidibMessageStreamFunction(connection);
                LOGGER.info("Created new bidibMessageStreamFunction:{}", (Object)bidibMessageStreamFunction);
                return bidibMessageStreamFunction;
            }
        };
        return factory;
    }

    @Bean
    @Scope(value="prototype")
    public BidibMessageStreamFunction bidibMessageStreamFunction(BidibConnection connection) {
        BidibMessageStreamFunction bidibMessageStreamFunction = new BidibMessageStreamFunction(this.camelContext(), connection.getConnectionId(), (Subject<AbstractMessageEvent>)connection.getSubjectMessages());
        return bidibMessageStreamFunction;
    }

    @Bean
    public CamelContext camelContext() {
        DefaultCamelContext camelContext = new DefaultCamelContext();
        return camelContext;
    }

    @Bean
    public BidibMessageProcessor bidibMessageProcessor() {
        return new BidibMessageProcessor();
    }
}

