package org.bidib.wizard.camel.stream;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.bidib.wizard.api.model.connection.AbstractMessageEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.subjects.Subject;

public class BidibMessageStreamFunction {

    private static final Logger LOGGER = LoggerFactory.getLogger(BidibMessageStreamFunction.class);

    private volatile Subject<AbstractMessageEvent> subjectBidibMessages;

    private String connectionId;

    private Disposable dispMessageSubscription;

    private final CamelContext camelContext;

    public BidibMessageStreamFunction(final CamelContext camelContext, String connectionId,
        final Subject<AbstractMessageEvent> subjectBidibMessages) {
        this.subjectBidibMessages = subjectBidibMessages;
        this.camelContext = camelContext;
        this.connectionId = connectionId;
    }

    @PostConstruct
    public void initialize() {

        LOGGER.info("The BidibMessageStreamFunction is started for connectionId: {}", connectionId);

        final ProducerTemplate producerTemplate = camelContext.createProducerTemplate();

        dispMessageSubscription = subjectBidibMessages.subscribe(event -> {

            LOGGER.info("Publish event: {}", event);

            producerTemplate
                .sendBodyAndHeader(EndpointDefines.DIRECT_BIDIB_MESSAGES, event, EndpointDefines.HEADER_CONNECTION_ID,
                    connectionId);
        }, err -> {
            LOGGER.warn("The message subscription signalled an error: {}", err.getMessage(), err);
        }, () -> {
            LOGGER.warn("The message subscription has completed.");
        });

    }

    @PreDestroy
    public void shutdown() {
        LOGGER.info("Shutdown the BidibMessageStreamFunction for connectionId: {}", connectionId);

        if (dispMessageSubscription != null) {
            dispMessageSubscription.dispose();
            dispMessageSubscription = null;
        }

    }

}
