/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.camel.stream;

import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.subjects.BehaviorSubject;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.bidib.api.json.types.ConnectionRegistryEvent;
import org.bidib.wizard.api.model.connection.BidibConnection;
import org.bidib.wizard.camel.config.MessageStreamConfiguration;
import org.bidib.wizard.camel.stream.BidibMessageStreamFactory;
import org.bidib.wizard.camel.stream.BidibMessageStreamFunction;
import org.bidib.wizard.camel.stream.processor.BidibMessageProcessor;
import org.bidib.wizard.core.model.connection.ConnectionRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Service;

@Service
@EnableConfigurationProperties(value={MessageStreamConfiguration.class})
public class ConnectionObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionObserver.class);
    @Autowired
    private MessageStreamConfiguration messageStreamConfiguration;
    @Autowired
    private ConnectionRegistry connectionRegistry;
    @Autowired
    private BidibMessageStreamFactory bidibMessageStreamFactory;
    private Map<String, BidibMessageStreamFunction> messageStreamRegistry = new HashMap<String, BidibMessageStreamFunction>();
    @Autowired
    private CamelContext context;
    @Autowired
    private BidibMessageProcessor bidibMessageProcessor;

    @PostConstruct
    public void initialize() {
        LOGGER.info("Initialize the ConnectionObserver.");
        this.context.start();
        BehaviorSubject connectionRegistrySubject = this.connectionRegistry.getConnectionRegistrySubject();
        connectionRegistrySubject.subscribe((Observer)new Observer<ConnectionRegistryEvent>(){

            public void onSubscribe(Disposable d) {
                LOGGER.info("Subscribed to connection registry changes, disposed: {}", (Object)d.isDisposed());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onNext(ConnectionRegistryEvent evt) {
                LOGGER.info("New connection event received from connection registry: {}", (Object)evt);
                String connectionId = evt.getConnectionId();
                switch (evt.getConnectionRegistryState()) {
                    case ADD: {
                        if (ConnectionObserver.this.messageStreamConfiguration.isStreamsEnabled()) {
                            ConnectionObserver.this.createStream(connectionId);
                            break;
                        }
                        LOGGER.info("No streams enabled, skip add connection.");
                        break;
                    }
                    default: {
                        Map<String, BidibMessageStreamFunction> map = ConnectionObserver.this.messageStreamRegistry;
                        synchronized (map) {
                            LOGGER.info("Remove messageStream from registry, connectionId: {}", (Object)connectionId);
                            BidibMessageStreamFunction messageStreamSafe = ConnectionObserver.this.messageStreamRegistry.remove(connectionId);
                            if (messageStreamSafe != null) {
                                messageStreamSafe.shutdown();
                            }
                            break;
                        }
                    }
                }
            }

            public void onError(Throwable e) {
                LOGGER.info("Subscription to connection registry changes has thrown an error: {}", e);
            }

            public void onComplete() {
                LOGGER.info("The subscription to connection registry changes has finished.");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createStream(String connectionId) {
        LOGGER.info("Create new messageStream for connectionId: {}", (Object)connectionId);
        BidibConnection connection = this.connectionRegistry.getConnection(connectionId);
        BidibMessageStreamFunction messageStream = this.bidibMessageStreamFactory.createMessageStream(connection);
        Map<String, BidibMessageStreamFunction> map = this.messageStreamRegistry;
        synchronized (map) {
            this.messageStreamRegistry.put(connectionId, messageStream);
        }
        LOGGER.info("Created new messageStream: {}", (Object)messageStream);
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() throws Exception {
                    this.from("direct:bidibmessages").process((Processor)ConnectionObserver.this.bidibMessageProcessor);
                }
            });
            LOGGER.info("Execute the stream passed.");
        }
        catch (Exception ex) {
            LOGGER.warn("Execute the stream failed.", (Throwable)ex);
        }
    }
}

