package org.bidib.wizard.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.util.function.Supplier;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingConstants;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.mvc.error.view.ErrorView;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.StandardDialog;
import com.jidesoft.dialog.StandardDialogPane;
import com.jidesoft.swing.JideBoxLayout;

public abstract class ExceptionDialog extends StandardDialog {

    private static final long serialVersionUID = 1L;

    public JComponent detailsPanel;

    public ExceptionDialog() throws HeadlessException {
        super((Frame) null, Resources.getString(ErrorView.class, "title"));

        setIconImage(ImageUtils.createImageIcon(getClass(), "/icons/wizard-logo2-48x48.png").getImage());
    }

    @Override
    public JComponent createBannerPanel() {
        return null;
    }

    public JComponent createDetailsPanel() {

        final String exceptionMessage = getExceptionMessageSupplier().get();

        JTextArea textArea = new JTextArea(exceptionMessage);
        textArea.setRows(10);

        // JLabel label = new JLabel(Resources.getString(ErrorView.class, "details"));

        JPanel panel = new JPanel(new BorderLayout(6, 6));
        panel.add(new JScrollPane(textArea));
        // panel.add(label, BorderLayout.BEFORE_FIRST_LINE);
        // label.setLabelFor(textArea);
        panel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        return panel;
    }

    protected abstract Supplier<String> getErrorMessageSupplier();

    protected abstract Supplier<String> getExceptionMessageSupplier();

    @Override
    protected StandardDialogPane createStandardDialogPane() {
        DefaultStandardDialogPane dialogPane = new DefaultStandardDialogPane() {
            private static final long serialVersionUID = 1L;

            @Override
            protected void layoutComponents(Component bannerPanel, Component contentPanel, ButtonPanel buttonPanel) {
                setLayout(new JideBoxLayout(this, BoxLayout.Y_AXIS));
                if (bannerPanel != null) {
                    add(bannerPanel);
                }
                if (contentPanel != null) {
                    add(contentPanel);
                }
                add(buttonPanel, JideBoxLayout.FIX);
                detailsPanel = createDetailsPanel();
                add(detailsPanel, JideBoxLayout.VARY);
                detailsPanel.setVisible(false);
            }
        };
        return dialogPane;
    }

    @Override
    public JComponent createContentPanel() {
        JPanel panel = new JPanel(new BorderLayout(10, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(20, 40, 40, 40));

        JLabel label = new JLabel(getErrorMessageSupplier().get());
        label.setHorizontalAlignment(SwingConstants.CENTER);

        panel.add(label, BorderLayout.CENTER);

        JLabel labelDetails = new JLabel(Resources.getString(ErrorView.class, "details"));
        panel.add(labelDetails, BorderLayout.AFTER_LAST_LINE);
        // label.setLabelFor(textArea);

        return panel;
    }

    @Override
    public ButtonPanel createButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        JButton closeButton = new JButton();
        JButton detailButton = new JButton();
        detailButton.setMnemonic('D');
        closeButton.setName(OK);
        buttonPanel.addButton(closeButton, ButtonPanel.AFFIRMATIVE_BUTTON);
        buttonPanel.addButton(detailButton, ButtonPanel.OTHER_BUTTON);

        closeButton.setAction(new AbstractAction("Close") {
            @Override
            public void actionPerformed(ActionEvent e) {
                setDialogResult(RESULT_AFFIRMED);
                setVisible(false);
                dispose();
            }
        });

        detailButton.setAction(new AbstractAction("Details >>") {
            @Override
            public void actionPerformed(ActionEvent e) {
                if (detailsPanel.isVisible()) {
                    detailsPanel.setVisible(false);
                    putValue(Action.NAME, "Details <<");
                    pack();
                }
                else {
                    detailsPanel.setVisible(true);
                    putValue(Action.NAME, "<< Details");
                    pack();
                }
            }
        });

        setDefaultCancelAction(closeButton.getAction());
        setDefaultAction(closeButton.getAction());
        getRootPane().setDefaultButton(closeButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        buttonPanel.setSizeConstraint(ButtonPanel.NO_LESS_THAN); // since the checkbox is quite wide, we don't want all
                                                                 // of them have the same size.
        return buttonPanel;
    }
}
