package org.bidib.wizard.mvc.accessory.view.panel;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRadioButton;

import org.bidib.jbidibc.messages.AddressData;
import org.bidib.jbidibc.messages.enums.AccessoryAddressingEnum;
import org.bidib.jbidibc.messages.enums.AddressTypeEnum;
import org.bidib.jbidibc.messages.enums.TimeBaseUnitEnum;
import org.bidib.jbidibc.messages.enums.TimingControlEnum;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.mvc.accessory.model.AccessoryBeanModel;
import org.bidib.wizard.mvc.accessory.model.AccessoryModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.validation.util.PropertyValidationSupport;

public class DccAccessoryPanel extends AbstractAccessoryPanel<AccessoryBeanModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DccAccessoryPanel.class);

    private static final String ENCODED_LOCAL_COLUMN_SPECS = "max(50dlu;pref), 3dlu, max(50dlu;pref), 3dlu, pref:grow";

    private static final String ENCODED_LOCAL_ROW_SPECS = "pref";

    private ValueModel timingControlModel;

    private final AccessoryBeanModel accessoryBeanModel;

    private JComponent[] timingControlButtons;

    private JButton aspectButtons[];

    public DccAccessoryPanel(final AccessoryModel accessoryModel) {
        super(accessoryModel);
        accessoryBeanModel = new AccessoryBeanModel();
    }

    @Override
    protected AccessoryBeanModel getAccessoryBeanModel() {
        return accessoryBeanModel;
    }

    @Override
    protected void addSpecificComponents(final FormBuilder builder, final int[] rowHolder) {
        // goto next line
        int row = rowHolder[0];
        row += 2;
        builder.appendRows("3dlu, p");
        // builder.nextLine();

        // timing control
        builder.add(Resources.getString(AbstractAccessoryPanel.class, "timingControl")).xy(1, row);
        timingControlModel =
            new PropertyAdapter<AccessoryBeanModel>(accessoryBeanModel, AccessoryBeanModel.PROPERTYNAME_TIMING_CONTROL,
                true);
        timingControlButtons = new JComponent[TimingControlEnum.values().length];
        int index = 0;

        FormBuilder timingControlBuilder =
            FormBuilder.create().columns("pref, 3dlu, pref").rows(ENCODED_LOCAL_ROW_SPECS);

        int column = 1;
        for (TimingControlEnum timingControl : TimingControlEnum.values()) {

            JRadioButton radio =
                WizardComponentFactory
                    .createRadioButton(timingControlModel, timingControl,
                        Resources.getString(TimingControlEnum.class, timingControl.getKey()));
            timingControlButtons[index++] = radio;

            // add radio button
            timingControlBuilder.add(radio).xy(column, 1);

            column += 2;
        }
        builder.add(timingControlBuilder.build()).xyw(3, row, 9);

        row += 2;
        builder.appendRows("3dlu, p");
        // builder.nextLine();

        FormBuilder localBuilder =
            FormBuilder.create().columns(ENCODED_LOCAL_COLUMN_SPECS).rows(ENCODED_LOCAL_ROW_SPECS);
        // add the aspects
        aspectButtons = new JButton[2];
        column = 1;
        for (int aspect = 0; aspect < 2; aspect++) {

            JButton aspectButton =
                new JButton(new AbstractAction(Resources.getString(DccAccessoryPanel.class, "aspect-" + aspect)) {
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        // set aspect button was pressed
                        Integer aspect = (Integer) ((JButton) e.getSource()).getClientProperty("aspect");
                        LOGGER.info("Pressed button: {}, aspect: {}", e.getActionCommand(), aspect);

                        int directDccAddress =
                            accessoryBeanModel.getDccAddress()
                                + (accessoryBeanModel.getAccessoryAddressing() == AccessoryAddressingEnum.RCN_213 ? 3
                                    : 0);

                        addLogText(
                            "Send DCC accessory request, address: {}, aspect: {}, switch time: {}, time base: {}",
                            directDccAddress, aspect, accessoryBeanModel.getSwitchTime(),
                            Resources.getString(TimeBaseUnitEnum.class, accessoryBeanModel.getTimeBaseUnit().getKey()));

                        // set the aspect triggers the property change listener
                        accessoryBeanModel.setAcknowledge(null);
                        accessoryBeanModel.setAspect(aspect);
                        // send the request
                        AddressData addressData = new AddressData(directDccAddress, AddressTypeEnum.ACCESSORY);
                        sendRequest(addressData, accessoryBeanModel.getAspect(), accessoryBeanModel.getSwitchTime(),
                            accessoryBeanModel.getTimeBaseUnit(), accessoryBeanModel.getTimingControl());
                    }
                });
            aspectButton.putClientProperty("aspect", Integer.valueOf(aspect));
            aspectButton.setEnabled(false);
            aspectButtons[aspect] = aspectButton;
            localBuilder.add(aspectButton).xy(column, 1);

            column += 2;
        }
        builder.add(localBuilder.build()).xyw(1, row, 9);

        // update the row holder
        rowHolder[0] = row;
    }

    @Override
    protected void addSpecificValidation() {

        // if the model is valid, the aspect buttons are enabled.
        for (int aspect = aspectButtons.length - 1; aspect > -1; aspect--) {
            PropertyConnector
                .connect(accessoryValidationModel, AccessoryValidationResultModel.PROPERTY_VALID_STATE,
                    aspectButtons[aspect], "enabled");
        }
    }

    @Override
    protected void validateSpecificPanel(PropertyValidationSupport support) {

    }

    @Override
    protected void disableInputElements() {
        // TODO use a new different property here
        accessoryValidationModel.setValidState(false);
    }

    @Override
    protected void enableInputElements() {
        // TODO use a new different property here
        accessoryValidationModel.setValidState(true);
    }

    private static final int MAX_ADDRESS = 2047;

    @Override
    protected int getMaxAddress() {
        return MAX_ADDRESS;
    }
}
