package org.bidib.wizard.mvc.common.view.slider;

import javax.swing.JSlider;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JZeroSlider extends JSlider {
    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(JZeroSlider.class);

    public JZeroSlider(int min, int max, int value) {
        super(min, max, value);
    }

    public JZeroSlider() {
        super(new ZeroBoundedRangeModel());
    }

    public void stop() {
        LOGGER.info("Stop is called.");
        setValue(0);

        if (getModel() instanceof ZeroBoundedRangeModel) {
            ((ZeroBoundedRangeModel) getModel()).resetIgnoreNewValue();
        }
    }

    @Override
    public void setValueIsAdjusting(boolean isAdjusting) {
        LOGGER.debug("isAdjusting: {}", isAdjusting);

        super.setValueIsAdjusting(isAdjusting);
    }
}
