package org.bidib.wizard.mvc.common.view.slider;

import javax.swing.DefaultBoundedRangeModel;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroBoundedRangeModel extends DefaultBoundedRangeModel {

    private static final Logger LOGGER = LoggerFactory.getLogger(ZeroBoundedRangeModel.class);

    private static final long serialVersionUID = 1L;

    private boolean ignoreNewValue;

    public ZeroBoundedRangeModel() {

    }

    @Override
    public void setValueIsAdjusting(boolean isAdjusting) {

        if (!isAdjusting) {
            resetIgnoreNewValue();
        }

        super.setValueIsAdjusting(isAdjusting);
    }

    public void resetIgnoreNewValue() {
        LOGGER.info("Reset ignoreNewValue.");
        ignoreNewValue = false;
    }

    public void setValue(int value) {

        int oldValue = getValue();

        boolean isAdjusting = getValueIsAdjusting();

        LOGGER
            .info("Set the new slider value: {}, oldValue: {}, ignoreNewValue: {}, isAdjusting: {}", value, oldValue,
                ignoreNewValue, isAdjusting);

        if (oldValue > 0 && value <= 0 && isAdjusting) {
            LOGGER.info("Must stop at value 0.");
            ignoreNewValue = true;
            value = 0;
        }
        else if (oldValue < 0 && value >= 0 && isAdjusting) {
            LOGGER.info("Must stop at value 0.");
            ignoreNewValue = true;
            value = 0;
        }
        else if (ignoreNewValue) {
            LOGGER.info("IgnoreNewValue is true. Set value = 0");
            value = 0;
        }
        super.setValue(value);
    }

}
