package org.bidib.wizard.mvc.main.controller.docking;

import org.bidib.wizard.client.common.view.DockKeys;
import org.bidib.wizard.mvc.booster.controller.BoosterTableController;
import org.bidib.wizard.mvc.console.controller.ConsoleController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableResolver;

public class DefaultDockableResolver implements DockableResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDockableResolver.class);

    @Autowired
    private ApplicationContext context;

    @Override
    public Dockable resolveDockable(String keyName) {

        // TODO create an interface that is implemented by every controller to let the controllers be injected here.
        // But make sure it does not create the controllers to early.

        LOGGER.info("Resolve dockable with keyName: {}", keyName);
        Dockable dockable = null;
        switch (keyName) {
            case DockKeys.CONSOLE_VIEW:

                // create the consoleController
                ConsoleController consoleController = context.getBean(ConsoleController.class);
                dockable = consoleController.createDockable();
                break;
            case DockKeys.BOOSTER_TABLE_VIEW:
                // create the boosterTableController
                BoosterTableController boosterTableController = context.getBean(BoosterTableController.class);
                dockable = boosterTableController.createDockable();
                break;
            default:
                LOGGER.warn("Unresolved dockable with keyName: {}", keyName);
                break;
        }

        LOGGER.info("The resolved dockable: {}", dockable);

        return dockable;
    }

}
