package org.bidib.wizard.mvc.main.view.exchange;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;

import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.dialog.EscapeDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;

public abstract class ExportNodeOptionsDialog extends EscapeDialog {

    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(ExportNodeOptionsDialog.class);

    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, fill:50dlu:grow";

    private int result = JOptionPane.CANCEL_OPTION;

    private final Component additionalPanel;

    public ExportNodeOptionsDialog(Frame parent, String title, final NodeInterface node) {

        super(parent, title, true);

        getContentPane().setLayout(new BorderLayout());

        boolean debug = false;
        FormBuilder builder =
            FormBuilder
                .create().columns(ENCODED_DIALOG_COLUMN_SPECS).rows("fill:p:grow, 3dlu, p")
                .panel(debug ? new FormDebugPanel() : new JPanel());

        builder.border(Paddings.DIALOG);

        this.additionalPanel = getAdditionalPanel();
        builder.add(additionalPanel).xyw(1, 1, 3);

        JButton applyButton = new JButton("OK");
        applyButton.addActionListener(evt -> setResult(JOptionPane.OK_OPTION));
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(evt -> setResult(JOptionPane.CANCEL_OPTION));

        JPanel buttons = ButtonBarBuilder.create().addGlue().addButton(applyButton, cancelButton).build();
        builder.add(buttons).xyw(1, 3, 3);

        getContentPane().add(builder.build());

        pack();

        setLocationRelativeTo(parent);
        setMinimumSize(getSize());

    };

    protected abstract Component getAdditionalPanel();

    protected void setResult(int result) {
        LOGGER.info("Set the result: {}", result);

        this.result = result;

        setVisible(false);
    }

    public int getResult() {
        return result;
    }
}
