package org.bidib.wizard.mvc.main.view.panel.renderer;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

import org.bidib.jbidibc.messages.enums.LoadTypeEnum;
import org.bidib.wizard.api.locale.Resources;

public final class LoadTypeCellRenderer implements ListCellRenderer<LoadTypeEnum> {
    protected final DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

    private Map<String, String> textMap = new HashMap<>();

    public LoadTypeCellRenderer() {

        for (LoadTypeEnum loadType : LoadTypeEnum.values()) {
            textMap.put(loadType.getKey(), Resources.getString(LoadTypeEnum.class, loadType.getKey()));
        }
    }

    @Override
    public Component getListCellRendererComponent(
        JList<? extends LoadTypeEnum> list, LoadTypeEnum value, int index, boolean isSelected, boolean cellHasFocus) {

        JLabel renderer =
            (JLabel) defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);

        if (value != null) {
            renderer.setText(textMap.get(value.getKey()));
        }

        return renderer;
    }
}