package org.bidib.wizard.mvc.main.view.table;

import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

import org.bidib.jbidibc.messages.BidibLibrary;
import org.bidib.wizard.client.common.controller.NodeSelectionProvider;
import org.bidib.wizard.client.common.table.AbstractPortHierarchicalTable;
import org.bidib.wizard.client.common.view.renderer.DmxChannelRenderer;
import org.bidib.wizard.client.common.view.renderer.LocalPortConfigErrorAwareRenderer;
import org.bidib.wizard.client.common.view.slider.SliderRenderer;
import org.bidib.wizard.model.ports.BacklightPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.mvc.common.view.slider.ConfigXAwareSliderRenderer;
import org.bidib.wizard.mvc.main.model.BacklightPortTableModel;

import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.RowStripeTableStyleProvider;
import com.jidesoft.grid.TableColumnChooser;

import io.reactivex.rxjava3.subjects.PublishSubject;

public class BacklightPortTable extends AbstractPortHierarchicalTable<BacklightPort> {
    private static final long serialVersionUID = 1L;

    private final BacklightPortTableModel backlightPortTableModel;

    public BacklightPortTable(final BacklightPortTableModel backlightPortTableModel, String emptyTableText) {
        super(backlightPortTableModel, emptyTableText);

        this.backlightPortTableModel = backlightPortTableModel;
    }

    @Override
    protected BacklightPortEditorPanel createPortEditorPanel(
        final BacklightPort port, int row, final PublishSubject<PortConfigChangeEvent> portConfigChangeEventSubject, final NodeSelectionProvider nodeSelectionProvider) {
        BacklightPortEditorPanel editorPanel =
            new BacklightPortEditorPanel(port,
                backlightPort -> this.backlightPortTableModel.updatePortConfig(backlightPort),
                backlightPort -> this.backlightPortTableModel.fireTestButtonPressed(backlightPort),
                    backlightPort -> this.backlightPortTableModel.refreshRow(backlightPort, changedRow -> repaint(getCellRect(changedRow, BacklightPortTableModel.COLUMN_LABEL, true))), nodeSelectionProvider);
        editorPanel.createComponent();

        return editorPanel;
    }

    @Override
    public void clearTable() {

    }

    @Override
    protected RowStripeTableStyleProvider createTableStyleProvider(final TableModel portTableModel) {
        final RowStripeTableStyleProvider tableStyleProvider =
            new RowStripeTableStyleProvider(UIManager.getColor("tableRowStripe.background"),
                UIManager.getColor("tableRowStripe.alternativeBackground")) {

                @Override
                public CellStyle getCellStyleAt(JTable table, int rowIndex, int columnIndex) {

                    if (columnIndex != BacklightPortTableModel.COLUMN_LABEL) {
                        return super.getCellStyleAt(table, rowIndex, columnIndex);
                    }
                    else {

                        Port<?> port = (Port<?>) portTableModel.getValueAt(rowIndex, columnIndex);
                        CellStyle style = super.getCellStyleAt(table, rowIndex, columnIndex);
                        if (!port.isEnabled()) {
                            style = new CellStyle(style);
                            style.setForeground(disabledForeground);
                            return style;
                        }
                        return style;

                    }
                }
            };
        return tableStyleProvider;
    }

    @Override
    public void prepareTableColumns() {

        TableColumn tc = getColumnModel().getColumn(BacklightPortTableModel.COLUMN_LABEL);
        tc.setCellRenderer(new LocalPortConfigErrorAwareRenderer(BacklightPortTableModel.COLUMN_LABEL));
        tc.setIdentifier(Integer.valueOf(BacklightPortTableModel.COLUMN_LABEL));

        // dimm columns
        tc = getColumnModel().getColumn(BacklightPortTableModel.COLUMN_DIM_SLOPE_DOWN);
        tc.setIdentifier(Integer.valueOf(BacklightPortTableModel.COLUMN_DIM_SLOPE_DOWN));

        // sliderEditorDimmMin = new SliderEditor(1, 255, 10, true);
        // tc.setCellEditor(sliderEditorDimmMin);
        ConfigXAwareSliderRenderer sliderRendererDimmMin =
            new ConfigXAwareSliderRenderer(1, 255, 10, BidibLibrary.BIDIB_PCFG_DIMM_DOWN,
                BidibLibrary.BIDIB_PCFG_DIMM_DOWN_8_8);
        tc.setCellRenderer(sliderRendererDimmMin);

        tc = getColumnModel().getColumn(BacklightPortTableModel.COLUMN_DIM_SLOPE_UP);
        tc.setIdentifier(Integer.valueOf(BacklightPortTableModel.COLUMN_DIM_SLOPE_UP));
        // sliderEditorDimmMax = new SliderEditor(1, 255, 10, true);
        // tc.setCellEditor(sliderEditorDimmMax);
        ConfigXAwareSliderRenderer sliderRendererDimmMax =
            new ConfigXAwareSliderRenderer(1, 255, 10, BidibLibrary.BIDIB_PCFG_DIMM_UP,
                BidibLibrary.BIDIB_PCFG_DIMM_UP_8_8);
        tc.setCellRenderer(sliderRendererDimmMax);

        TableColumn tcDmxMapping = getColumnModel().getColumn(BacklightPortTableModel.COLUMN_DMX_MAPPING);
        tcDmxMapping.setIdentifier(Integer.valueOf(BacklightPortTableModel.COLUMN_DMX_MAPPING));
        tcDmxMapping.setMaxWidth(80);
        tcDmxMapping.setCellRenderer(new DmxChannelRenderer());
        // tcDmxMapping.setCellEditor(new DmxChannelCellEditor(1, 0x100));

        tc = getColumnModel().getColumn(BacklightPortTableModel.COLUMN_VALUE);
        tc.setIdentifier(Integer.valueOf(BacklightPortTableModel.COLUMN_VALUE));
        tc.setCellRenderer(new SliderRenderer(0, 100, 10));
        // final SliderEditor valueSliderEditor = new SliderEditor(0, 100, 10, false);
        // tc.setCellEditor(valueSliderEditor);
        // valueSliderEditor.setSliderValueChangeListener(new SliderValueChangeListener() {
        //
        // @Override
        // public void stateChanged(ChangeEvent e, boolean isAdjusting, int value, Integer column, Integer row) {
        // LOGGER
        // .info("The slider state has changed, isAdjusting: {}, value: {}, column: {}, row: {}", isAdjusting,
        // value, column, row);
        //
        // if (isDmxNode != null && isDmxNode.get()) {
        //
        // // only handle if adjusting
        // if (isAdjusting) {
        // // value is adjusting
        // BacklightPort port =
        // (BacklightPort) getBacklightPortTableModel()
        // .getValueAt(row, BacklightPortTableModel.COLUMN_PORT_INSTANCE);
        //
        // port.setAdjusting(true);
        // if (port.getPreAdjustingValue() < 0) {
        // LOGGER.info("Set the pre-adjusting value: {}, row: {}", port.getValue(), row);
        // port.setPreAdjustingValue(port.getValue());
        // }
        //
        // LOGGER
        // .info("Update during adjusting backlight port: {}, row: {}, absolute value: {}",
        // port.getDebugString(), row, BacklightPort.getAbsoluteValue(value));
        // if (!updateModelInProgress.get()) {
        //
        // // set the value on the temporary port
        // final BacklightPort backlightPort = new BacklightPort();
        // backlightPort.setId(port.getId());
        // backlightPort.setValue(BacklightPort.getAbsoluteValue(value), true);
        // backlightPort.setAdjusting(true);
        //
        // getBacklightPortTableModel().fireTestButtonPressed(backlightPort);
        // }
        // else {
        // LOGGER
        // .debug("Do not send new port status to backlight because the model was updated: {}",
        // port);
        // }
        // }
        // }
        // }
        // });

        // remove the column with the port instance
        TableColumnChooser.hideColumn(this, BacklightPortTableModel.COLUMN_PORT_INSTANCE);

    }
}
