package org.bidib.wizard.mvc.main.view.table;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;

import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;

import org.bidib.wizard.client.common.view.slider.SliderEditor;
import org.bidib.wizard.mvc.common.view.slider.JZeroSlider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MotorSliderEditor extends SliderEditor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MotorSliderEditor.class);

    private static final long serialVersionUID = 1L;

    private final DecimalFormat format = new DecimalFormat("##0");

    private JButton stopButton;

    public MotorSliderEditor(int minValue, int maxValue, int value) {
        super(minValue, maxValue, value);
    }

    // @Override
    // public void createComponent(int initialValue) {
    //
    // super.createComponent(initialValue);
    //
    // Dimension dim = sliderValue.getMinimumSize();
    // dim = new Dimension(dim.width + 10, dim.height);
    // sliderValue.setPreferredSize(dim);
    // sliderValue.setMaximumSize(dim);
    // sliderValue.setMinimumSize(dim);
    //
    // slider.setMajorTickSpacing(slider.getMaximum());
    // slider.setPaintTicks(true);
    //
    // stopButton = new JButton("STOP");
    // stopButton.addActionListener(new ActionListener() {
    //
    // @Override
    // public void actionPerformed(ActionEvent e) {
    //
    // if (slider instanceof JZeroSlider) {
    // ((JZeroSlider) slider).stop();
    // }
    //
    // // slider.setValue(0);
    // }
    // });
    // panel.add(stopButton);
    // panel.add(Box.createRigidArea(new Dimension(3, 0)));
    //
    // panel.validate();
    // }

    @Override
    protected void addComponents(final JPanel panel, JComponent... components) {
        panel.add(slider);

        panel.add(Box.createHorizontalStrut(2));
        panel.add(sliderValue);
        panel.add(Box.createRigidArea(new Dimension(3, 0)));

        stopButton = new JButton("STOP");
        stopButton.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {

                if (slider instanceof JZeroSlider) {
                    ((JZeroSlider) slider).stop();
                }

                // slider.setValue(0);
            }
        });
        panel.add(stopButton);
        // panel.add(Box.createRigidArea(new Dimension(3, 0)));
    }

    @Override
    protected void createJSlider(int minValue, int maxValue, int initialValue) {

        slider = new JZeroSlider(minValue, maxValue, initialValue);
    }

    @Override
    protected void prepareSliderTextLabel(int maxValue, int initialValue) {
        super.prepareSliderTextLabel(maxValue, initialValue);
        // the slider must not be opaque
        slider.setOpaque(false);
    }

    @Override
    protected void updateSliderTextValue(JTable table, int value, boolean isSelected, int row, int column) {
        LOGGER.trace("updateSliderTextValue, value: {}, isSelected: {}", value, isSelected);

        // if (table != null) {
        //
        // final MotorPortTableModel tableModel = (MotorPortTableModel) table.getModel();
        // final MotorPort port = (MotorPort) tableModel.getValueAt(row, MotorPortTableModel.COLUMN_PORT_INSTANCE);
        // }

        String newValue = format.format(value);
        LOGGER.trace("Set the new value: {}", newValue);

        sliderValue.setText(newValue);
    }

    public void stop() {
        slider.setValue(0);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        stopButton.setEnabled(enabled);
    }
}