package org.bidib.wizard.mvc.main.view.table;

import java.awt.Component;
import java.awt.Dimension;

import javax.swing.AbstractCellEditor;
import javax.swing.BoxLayout;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.table.TableCellEditor;

import org.apache.commons.lang3.StringUtils;
import org.bidib.wizard.client.common.view.validation.IntegerInputValidationDocument;
import org.bidib.wizard.client.common.view.validation.RangeValidationCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberWithLabelEditor extends AbstractCellEditor implements TableCellEditor, RangeValidationCallback {
    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(NumberWithLabelEditor.class);

    private final JPanel panel = new JPanel();

    private final JFormattedTextField textField;

    private final JLabel leftLabel;

    private final JLabel rightLabel;

    private int minimum;

    private int maximum;

    public NumberWithLabelEditor(String leftText, String rightText, int maximum) {
        this.maximum = maximum;

        textField = new JFormattedTextField();
        IntegerInputValidationDocument doc =
            new IntegerInputValidationDocument(3, IntegerInputValidationDocument.NUMERIC);
        doc.setRangeValidationCallback(this);
        textField.setDocument(doc);

        textField.setHorizontalAlignment(SwingConstants.RIGHT);

        Dimension currentDim = textField.getPreferredSize();
        textField.setPreferredSize(new Dimension(30, currentDim.height));
        textField.setMinimumSize(new Dimension(30, currentDim.height));

        leftLabel = new JLabel(leftText);
        leftLabel.setFocusable(false);
        rightLabel = new JLabel(rightText);
        rightLabel.setFocusable(false);

        panel.setFocusCycleRoot(true);

        panel.setLayout(new BoxLayout(panel, BoxLayout.LINE_AXIS));

        panel.add(leftLabel);
        panel.add(textField);
        panel.add(rightLabel);
    }

    public NumberWithLabelEditor(String leftText, String rightText) {
        this(leftText, rightText, 255);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (isSelected) {
            panel.setForeground(table.getSelectionForeground());
            panel.setBackground(table.getSelectionBackground());
        }
        else {
            panel.setForeground(table.getForeground());
            panel.setBackground(table.getBackground());
        }
        LOGGER.debug("Set value in editor: {}", value);
        textField.setText(value != null ? value.toString() : "");
        return panel;
    }

    @Override
    public Object getCellEditorValue() {
        try {
            if (StringUtils.isNotBlank(textField.getText())) {
                return Integer.parseInt(textField.getText());
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Parse textfield value failed.", ex);
        }
        return Integer.valueOf(0);
    }

    @Override
    public int getMinValue() {
        return minimum;
    }

    @Override
    public int getMaxValue() {
        return maximum;
    }
}
