package org.bidib.wizard.mvc.position.view;

import java.awt.BorderLayout;
import java.awt.Component;

import javax.swing.JPanel;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.view.DockKeys;
import org.bidib.wizard.mvc.position.controller.FeedbackPositionController;
import org.bidib.wizard.mvc.position.model.FeedbackPositionModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;

public class FeedbackPositionView implements Dockable {

    private static final Logger LOGGER = LoggerFactory.getLogger(FeedbackPositionView.class);

    private final JPanel contentPanel;

    private final FeedbackPositionListPanel feedbackPositionListPanel;

    public FeedbackPositionView(final FeedbackPositionController controller,
        final FeedbackPositionModel feedbackPositionModel) {

        DockKeys.DOCKKEY_FEEDBACK_POSITION_VIEW.setName(Resources.getString(getClass(), "title"));
        DockKeys.DOCKKEY_FEEDBACK_POSITION_VIEW.setFloatEnabled(true);
        DockKeys.DOCKKEY_FEEDBACK_POSITION_VIEW.setAutoHideEnabled(false);

        LOGGER.info("Create new FeedbackPositionView");

        contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());

        feedbackPositionListPanel = new FeedbackPositionListPanel(controller, feedbackPositionModel);

        contentPanel.add(feedbackPositionListPanel, BorderLayout.CENTER);
    }

    @Override
    public DockKey getDockKey() {
        return DockKeys.DOCKKEY_FEEDBACK_POSITION_VIEW;
    }

    @Override
    public Component getComponent() {
        return contentPanel;
    }

    public void cleanup() {
        if (feedbackPositionListPanel != null) {

            feedbackPositionListPanel.cleanup();
        }

    }

    public void refreshView() {
        this.feedbackPositionListPanel.listChanged();
    }

}
