package org.bidib.wizard.mvc.preferences.model;

import java.time.DayOfWeek;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;

import org.apache.commons.lang3.SystemUtils;
import org.bidib.jbidibc.netbidib.pairingstore.PairingStore;
import org.bidib.wizard.api.model.common.CommPort;
import org.bidib.wizard.common.model.settings.ExperimentalSettingsInterface;
import org.bidib.wizard.common.model.settings.GlobalSettingsInterface;
import org.bidib.wizard.common.model.settings.MiscSettingsInterface;
import org.bidib.wizard.common.model.settings.NetBidibSettingsInterface;
import org.bidib.wizard.common.model.settings.WizardSettingsInterface;
import org.bidib.wizard.mvc.preferences.model.listener.PreferencesModelListener;

import com.jgoodies.binding.beans.Model;
import com.jgoodies.common.collect.ArrayListModel;

public class PreferencesModel extends Model {
    private static final long serialVersionUID = 1L;

    private final Collection<PreferencesModelListener> listeners = new LinkedList<PreferencesModelListener>();

    private final Collection<CommPort> commPorts = new HashSet<CommPort>();

    private ArrayListModel<String> serialProviderList = new ArrayListModel<>();

    private ArrayListModel<DayOfWeek> dayOfWeekList = new ArrayListModel<>();

    private ArrayListModel<String> languageList = new ArrayListModel<>();

    private final GlobalSettingsInterface globalSettings;

    private final WizardSettingsInterface wizardSettings;

    private final MiscSettingsInterface miscSettings;

    private final ExperimentalSettingsInterface experimentalSettings;

    private final NetBidibSettingsInterface netBidibSettings;

    private final PairingStore pairingStore;

    public PreferencesModel(final GlobalSettingsInterface globalSettings, final WizardSettingsInterface wizardSettings,
        final MiscSettingsInterface miscSettings, final ExperimentalSettingsInterface experimentalSettings,
        final NetBidibSettingsInterface netBidibSettings, final PairingStore pairingStore) {
        serialProviderList.add("RXTX");
        serialProviderList.add("SCM");
        serialProviderList.add("SPSW");
        serialProviderList.add("JSerialComm");
        serialProviderList.add("PureJavaComm");

        // FTDI is currently only supported on Windows
        if (SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_MAC_OSX) {
            serialProviderList.add("FTDI");
        }

        // TODO add days of week
        dayOfWeekList.add(DayOfWeek.SUNDAY);
        dayOfWeekList.add(DayOfWeek.MONDAY);
        dayOfWeekList.add(DayOfWeek.TUESDAY);
        dayOfWeekList.add(DayOfWeek.WEDNESDAY);
        dayOfWeekList.add(DayOfWeek.THURSDAY);
        dayOfWeekList.add(DayOfWeek.FRIDAY);
        dayOfWeekList.add(DayOfWeek.SATURDAY);

        languageList.add("de");
        languageList.add("en");
        languageList.add("nl");

        this.globalSettings = globalSettings;
        this.wizardSettings = wizardSettings;
        this.miscSettings = miscSettings;
        this.experimentalSettings = experimentalSettings;
        this.netBidibSettings = netBidibSettings;
        this.pairingStore = pairingStore;
    }

    public void addPreferencesModelListener(PreferencesModelListener l) {
        listeners.add(l);
    }

    private void fireCommPortsChanged() {
        for (PreferencesModelListener l : listeners) {
            l.commPortsChanged();
        }
    }

    public Collection<CommPort> getAvailableCommPorts() {
        return commPorts;
    }

    /**
     * Set the commPorts and notify the listeners
     * 
     * @param commPorts
     *            the commPorts to set
     */
    public void setAvailableCommPorts(Collection<CommPort> commPorts) {
        this.commPorts.clear();
        this.commPorts.addAll(commPorts);
        fireCommPortsChanged();
    }

    /**
     * @return the serial provider list
     */
    public ArrayListModel<String> getSerialProviderList() {
        return serialProviderList;
    }


    /**
     * @return the day of week list
     */
    public ArrayListModel<DayOfWeek> getDayOfWeekList() {
        return dayOfWeekList;
    }

    public ArrayListModel<String> getLanguageList() {
        return languageList;
    }

    /**
     * @return the globalSettings
     */
    public GlobalSettingsInterface getGlobalSettings() {
        return globalSettings;
    }

    /**
     * @return the wizardSettings
     */
    public WizardSettingsInterface getWizardSettings() {
        return wizardSettings;
    }

    /**
     * @return the miscSettings
     */
    public MiscSettingsInterface getMiscSettings() {
        return miscSettings;
    }

    /**
     * @return the experimentalSettings
     */
    public ExperimentalSettingsInterface getExperimentalSettings() {
        return experimentalSettings;
    }

    /**
     * @return the netBidibSettings
     */
    public NetBidibSettingsInterface getNetBidibSettings() {
        return netBidibSettings;
    }

    /**
     * @return the pairingStore
     */
    public PairingStore getPairingStore() {
        return pairingStore;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("PreferencesModel, commPorts: ").append(commPorts);
        return sb.toString();
    }
}
