/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.config;

import com.jidesoft.utils.ThreadCheckingRepaintManager;
import java.awt.EventQueue;
import javax.swing.RepaintManager;
import org.apache.commons.lang3.SystemUtils;
import org.bidib.wizard.common.context.DefaultApplicationContext;
import org.bidib.wizard.main.BiDiBWizardStandaloneApplication;
import org.bidib.wizard.mvc.error.controller.ErrorController;
import org.bidib.wizard.mvc.main.controller.DefaultBidibPiController;
import org.bidib.wizard.mvc.main.controller.MainController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ApplicationRunnerConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationRunnerConfig.class);

    @Bean
    ApplicationRunner applicationRunner(ApplicationContext ctx) {
        return args -> EventQueue.invokeLater(() -> {
            LOGGER.info("Create the application context from the EDT. Started the spring boot application.");
            try {
                RepaintManager.setCurrentManager((RepaintManager)new ThreadCheckingRepaintManager());
                MainController mainController = (MainController)ctx.getBean(MainController.class);
                org.bidib.wizard.api.context.ApplicationContext applicationContext = DefaultApplicationContext.getInstance();
                applicationContext.register("SpringContext", (Object)ctx);
                if (SystemUtils.IS_OS_LINUX) {
                    LoggerFactory.getLogger(BiDiBWizardStandaloneApplication.class).info("Check if we are running on BiDiB-Pi infrastructure.");
                    try {
                        DefaultBidibPiController bidibPiController = new DefaultBidibPiController();
                        bidibPiController.start(applicationContext);
                        LoggerFactory.getLogger(BiDiBWizardStandaloneApplication.class).info("The Pi connector was initialized.");
                    }
                    catch (IllegalArgumentException ex) {
                        LoggerFactory.getLogger(BiDiBWizardStandaloneApplication.class).warn("The Pi connector was not initialized.");
                    }
                }
                new ErrorController().start(() -> mainController.hasStartupPassed());
                mainController.start();
            }
            catch (Exception ex) {
                LOGGER.warn("Start application failed.", (Throwable)ex);
                SpringApplication.exit((ApplicationContext)ctx, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 1});
            }
        });
    }
}

