/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.dialog;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JDialog;
import org.bidib.wizard.common.utils.ImageUtils;

public abstract class EscapeDialog
extends JDialog
implements ContainerListener,
KeyListener {
    private static final long serialVersionUID = 1L;

    public EscapeDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.setIconImage(ImageUtils.createImageIcon(EscapeDialog.class, (String)"/icons/wizard-logo2-48x48.png").getImage());
        this.addKeyAndContainerListenerRecursively((Component)this);
    }

    private void addKeyAndContainerListenerRecursively(Component c) {
        c.removeKeyListener((KeyListener)this);
        c.addKeyListener((KeyListener)this);
        if (c instanceof Container) {
            Container cont = (Container)c;
            cont.removeContainerListener((ContainerListener)this);
            cont.addContainerListener((ContainerListener)this);
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.addKeyAndContainerListenerRecursively(children[i]);
            }
        }
    }

    private void removeKeyAndContainerListenerRecursively(Component c) {
        c.removeKeyListener((KeyListener)this);
        if (c instanceof Container) {
            Container cont = (Container)c;
            cont.removeContainerListener((ContainerListener)this);
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.removeKeyAndContainerListenerRecursively(children[i]);
            }
        }
    }

    @Override
    public void componentAdded(ContainerEvent e) {
        this.addKeyAndContainerListenerRecursively(e.getChild());
    }

    @Override
    public void componentRemoved(ContainerEvent e) {
        this.removeKeyAndContainerListenerRecursively(e.getChild());
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 27) {
            this.performCancelAction(e);
        } else if (code == 10) {
            this.performEnterAction(e);
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    void performEnterAction(KeyEvent e) {
    }

    protected void performCancelAction(KeyEvent e) {
        this.setVisible(false);
    }
}

