/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.dialog;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.StandardDialog;
import com.jidesoft.dialog.StandardDialogPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.dialog.ExceptionDialog;
import org.bidib.wizard.mvc.error.view.ErrorView;

public abstract class ExceptionDialog
extends StandardDialog {
    private static final long serialVersionUID = 1L;
    public JComponent detailsPanel;

    public ExceptionDialog() throws HeadlessException {
        super((Frame)null, Resources.getString(ErrorView.class, (String)"title"));
        this.setIconImage(ImageUtils.createImageIcon(this.getClass(), (String)"/icons/wizard-logo2-48x48.png").getImage());
    }

    public JComponent createBannerPanel() {
        return null;
    }

    public JComponent createDetailsPanel() {
        String exceptionMessage = (String)this.getExceptionMessageSupplier().get();
        JTextArea textArea = new JTextArea(exceptionMessage);
        textArea.setRows(10);
        JPanel panel = new JPanel(new BorderLayout(6, 6));
        panel.add(new JScrollPane(textArea));
        panel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        return panel;
    }

    protected abstract Supplier<String> getErrorMessageSupplier();

    protected abstract Supplier<String> getExceptionMessageSupplier();

    protected StandardDialogPane createStandardDialogPane() {
        1 dialogPane = new /* Unavailable Anonymous Inner Class!! */;
        return dialogPane;
    }

    public JComponent createContentPanel() {
        JPanel panel = new JPanel(new BorderLayout(10, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(20, 40, 40, 40));
        JLabel label = new JLabel((String)this.getErrorMessageSupplier().get());
        label.setHorizontalAlignment(0);
        panel.add((Component)label, "Center");
        JLabel labelDetails = new JLabel(Resources.getString(ErrorView.class, (String)"details"));
        panel.add((Component)labelDetails, "Last");
        return panel;
    }

    public ButtonPanel createButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        JButton closeButton = new JButton();
        JButton detailButton = new JButton();
        detailButton.setMnemonic('D');
        closeButton.setName("OK");
        buttonPanel.addButton((AbstractButton)closeButton, (Object)"AFFIRMATIVE");
        buttonPanel.addButton((AbstractButton)detailButton, (Object)"ALTERNATIVE");
        closeButton.setAction((Action)new /* Unavailable Anonymous Inner Class!! */);
        detailButton.setAction((Action)new /* Unavailable Anonymous Inner Class!! */);
        this.setDefaultCancelAction(closeButton.getAction());
        this.setDefaultAction(closeButton.getAction());
        this.getRootPane().setDefaultButton(closeButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        buttonPanel.setSizeConstraint(1);
        return buttonPanel;
    }
}

