/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.common.view.slider;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.bidib.wizard.model.ports.ConfigurablePort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigXAwareSliderRenderer
extends JPanel
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigXAwareSliderRenderer.class);
    private JSlider slider;
    private JLabel sliderValue;
    private int labelWidth;
    private byte[] pcfgType;

    public ConfigXAwareSliderRenderer(int min, int max, int value, byte ... pcfgType) {
        this.pcfgType = pcfgType;
        this.slider = new JSlider(min, max, value);
        this.sliderValue = new JLabel();
        this.calculateValueDimension(max);
        this.sliderValue.setHorizontalAlignment(4);
        this.setLayout((LayoutManager)new BoxLayout((Container)this, 2));
        this.add((Component)this.slider);
        this.add(Box.createHorizontalStrut(2));
        this.add((Component)this.sliderValue);
    }

    private void calculateValueDimension(int maxValue) {
        JLabel tempLabel = new JLabel(Integer.toString(maxValue));
        tempLabel.doLayout();
        Dimension prefSize = tempLabel.getPreferredSize();
        this.labelWidth = prefSize.width;
        this.sliderValue.setPreferredSize(prefSize);
        this.sliderValue.setMinimumSize(prefSize);
        this.slider.setMinimumSize(prefSize);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        TableColumnModel columnModel = table.getColumnModel();
        TableColumn selectedColumn = columnModel.getColumn(column);
        int columnWidth = selectedColumn.getWidth();
        int columnHeight = table.getRowHeight();
        if (columnWidth > this.labelWidth) {
            this.slider.setSize(new Dimension(columnWidth - this.labelWidth, columnHeight));
        }
        this.setValue(value);
        try {
            Object portValue = table.getModel().getValueAt(row, 0);
            if (portValue instanceof ConfigurablePort) {
                ConfigurablePort port = (ConfigurablePort)portValue;
                boolean enabled = port.isEnabled() && port.isPortConfigKeySupported(this.pcfgType);
                this.slider.setEnabled(enabled);
                this.sliderValue.setEnabled(enabled);
                this.slider.setOpaque(false);
                this.sliderValue.setOpaque(false);
            } else {
                this.slider.setEnabled(true);
                this.sliderValue.setEnabled(true);
                this.slider.setOpaque(false);
                this.sliderValue.setOpaque(false);
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Enable or disable slider and slider value failed.");
        }
        this.slider.updateUI();
        return this;
    }

    protected void setValue(Object value) {
        if (value != null) {
            this.slider.setValue((Integer)value);
        } else {
            this.slider.setValue(0);
        }
        this.updateSliderTextValue(this.slider.getValue());
    }

    protected void updateSliderTextValue(int value) {
        String newValue = Integer.toString(value);
        LOGGER.trace("Set the new value: {}", (Object)newValue);
        this.sliderValue.setText(newValue);
    }

    public void setMaxValue(int maxValue) {
        this.calculateValueDimension(maxValue);
        if (this.slider != null) {
            this.slider.setMaximum(maxValue);
        }
    }

    public void setMinValue(int minValue) {
        if (this.slider != null) {
            this.slider.setMinimum(minValue);
        }
    }
}

