/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.common.view.slider;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.BoundedRangeModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeListener;
import org.bidib.wizard.client.common.view.slider.SliderValueChangeListener;
import org.bidib.wizard.mvc.common.view.slider.LabeledSlider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabeledSlider
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(LabeledSlider.class);
    protected JSlider slider;
    protected SliderValueLabel sliderValue;
    private SliderValueChangeListener sliderValueChangeListener;

    public LabeledSlider(int initialValue, int minValue, int maxValue, SliderValueChangeListener changeListener) {
        this((BoundedRangeModel)new DefaultBoundedRangeModel(initialValue, 0, minValue, maxValue), changeListener);
    }

    public LabeledSlider(BoundedRangeModel brm, SliderValueChangeListener changeListener) {
        this.setFocusCycleRoot(true);
        this.sliderValueChangeListener = changeListener;
        this.slider = new JSlider(brm);
    }

    public void createComponent() {
        this.sliderValue = new SliderValueLabel(this);
        this.slider.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.prepareSliderTextLabel(this.slider.getMaximum(), this.slider.getValue());
        this.setLayout((LayoutManager)new BoxLayout((Container)this, 2));
        this.add((Component)this.slider);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        this.add((Component)this.sliderValue);
        this.add(Box.createRigidArea(new Dimension(3, 0)));
        this.validate();
    }

    protected void prepareSliderTextLabel(int maxValue, int initialValue) {
        this.sliderValue.setHorizontalAlignment(11);
        this.sliderValue.setText(Integer.toString(maxValue));
        Dimension d = this.sliderValue.getMinimumSize();
        LOGGER.debug("Set the initial value: {}", (Object)initialValue);
        this.sliderValue.setText(Integer.toString(initialValue));
        LOGGER.trace("Current dimension: {}", (Object)d);
        this.sliderValue.setPreferredSize(d);
        this.sliderValue.setMaximumSize(d);
        this.sliderValue.setMinimumSize(d);
    }

    protected void updateSliderTextValue(int value) {
        String newValue = Integer.toString(value);
        LOGGER.trace("Set the new value: {}", (Object)newValue);
        this.sliderValue.setText(newValue);
    }

    public void setSliderValueChangeListener(SliderValueChangeListener sliderValueChangeListener) {
        this.sliderValueChangeListener = sliderValueChangeListener;
    }

    public void setDown() {
        LOGGER.trace("set slider value down: {}", (Object)this.slider.getValue());
        this.slider.setValue(this.slider.getValue() - 1);
    }

    public void setUp() {
        LOGGER.trace("set slider value up: {}", (Object)this.slider.getValue());
        this.slider.setValue(this.slider.getValue() + 1);
    }

    public void setValue(int value) {
        LOGGER.debug("Set the new value: {}", (Object)value);
        this.slider.getModel().setValueIsAdjusting(true);
        this.slider.setValue(value);
        this.sliderValue.setText(Integer.toString(value));
        this.slider.getModel().setValueIsAdjusting(false);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.slider.setEnabled(enabled);
        this.sliderValue.setEnabled(enabled);
    }
}

