/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.common.view.slider;

import javax.swing.DefaultBoundedRangeModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZeroBoundedRangeModel
extends DefaultBoundedRangeModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZeroBoundedRangeModel.class);
    private static final long serialVersionUID = 1L;
    private boolean ignoreNewValue;

    @Override
    public void setValueIsAdjusting(boolean isAdjusting) {
        if (!isAdjusting) {
            this.resetIgnoreNewValue();
        }
        super.setValueIsAdjusting(isAdjusting);
    }

    public void resetIgnoreNewValue() {
        LOGGER.info("Reset ignoreNewValue.");
        this.ignoreNewValue = false;
    }

    @Override
    public void setValue(int value) {
        int oldValue = this.getValue();
        boolean isAdjusting = this.getValueIsAdjusting();
        LOGGER.info("Set the new slider value: {}, oldValue: {}, ignoreNewValue: {}, isAdjusting: {}", new Object[]{value, oldValue, this.ignoreNewValue, isAdjusting});
        if (oldValue > 0 && value <= 0 && isAdjusting) {
            LOGGER.info("Must stop at value 0.");
            this.ignoreNewValue = true;
            value = 0;
        } else if (oldValue < 0 && value >= 0 && isAdjusting) {
            LOGGER.info("Must stop at value 0.");
            this.ignoreNewValue = true;
            value = 0;
        } else if (this.ignoreNewValue) {
            LOGGER.info("IgnoreNewValue is true. Set value = 0");
            value = 0;
        }
        super.setValue(value);
    }
}

