/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.dmx.view.panel;

import java.awt.Point;
import java.awt.event.ActionEvent;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.function.MacroFunction;
import org.bidib.wizard.model.ports.DmxChannel;
import org.bidib.wizard.model.status.MacroStatus;
import org.bidib.wizard.mvc.dmx.view.panel.DmxChartPanel;
import org.bidib.wizard.mvc.dmx.view.panel.DmxDataItem;
import org.bidib.wizard.mvc.dmx.view.panel.LocationAwareAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroAction
extends LocationAwareAction<DmxChannel> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MacroAction.class);
    private Macro macro;
    private DmxChannel dmxChannel;
    private DmxDataItem originalDataItem;

    public MacroAction(Macro macro, DmxChannel dmxChannel, DmxChartPanel dmxChartPanel, DmxDataItem originalDataItem) {
        super(macro.toString(), (Object)dmxChannel, dmxChartPanel);
        this.macro = macro;
        this.dmxChannel = dmxChannel;
        this.originalDataItem = originalDataItem;
    }

    public void actionPerformed(ActionEvent event) {
        Point currentMousePoint = this.dmxChartPanel.getCurrentMousePoint();
        String seriesKey = Integer.toString(this.dmxChannel.getChannelId());
        LOGGER.info("Selected key: {}, currentMousePoint: {}", (Object)seriesKey, (Object)currentMousePoint);
        int currentX = (int)Math.round(currentMousePoint.getX());
        int currentY = (int)Math.round(currentMousePoint.getY());
        if (this.originalDataItem != null) {
            LOGGER.info("Use the coordinates of the original data item: {}", (Object)this.originalDataItem);
            currentX = this.originalDataItem.getTimeOffset();
            currentY = this.originalDataItem.getBrightness();
        }
        LOGGER.info("Add new point at X: {}, Y: {}", (Object)currentX, (Object)currentY);
        MacroFunction macroFunction = new MacroFunction(MacroStatus.START, this.macro.getId());
        this.dmxChartPanel.createDataItem(seriesKey, currentX, currentY, macroFunction, this.dmxChannel, this.originalDataItem);
    }
}

