/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.dmx.view.utils;

import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SceneryUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SceneryUtils.class);

    public static int calculateSlowdown(TreeSet<Integer> delaySet) {
        Integer prevDelay = null;
        int maximalSlowdown = 255;
        int maximalDeviation = 0;
        do {
            for (Integer currentDelay : delaySet) {
                int currentSlowdown;
                if (currentDelay == 0) {
                    LOGGER.info("Skip the first point.");
                    prevDelay = currentDelay;
                    continue;
                }
                if (prevDelay != null) {
                    currentSlowdown = (currentDelay - prevDelay) / 20;
                    if (currentSlowdown < 0) {
                        currentSlowdown = -currentSlowdown;
                    }
                    LOGGER.debug("Current slowdown: {}, maximalSlowdown: {}", (Object)currentSlowdown, (Object)maximalSlowdown);
                    if (currentSlowdown < maximalSlowdown) {
                        maximalSlowdown = currentSlowdown;
                        LOGGER.debug("Set new maximalSlowdown: {}", (Object)maximalSlowdown);
                    }
                } else {
                    currentSlowdown = currentDelay / 20;
                    if (currentSlowdown < 0) {
                        currentSlowdown = -currentSlowdown;
                    }
                    LOGGER.debug("Current slowdown: {}, maximalSlowdown: {}", (Object)currentSlowdown, (Object)maximalSlowdown);
                    if (currentSlowdown < maximalSlowdown) {
                        maximalSlowdown = currentSlowdown;
                        LOGGER.info("Set new maximalSlowdown: {}", (Object)maximalSlowdown);
                    }
                }
                prevDelay = currentDelay;
            }
            LOGGER.info("Calculated maximalSlowdown: {}", (Object)maximalSlowdown);
            for (Integer currentDelay : delaySet) {
                if (maximalSlowdown == 0) {
                    LOGGER.warn("The calculated maximal slowdown is 0! Stop further optimization and return slowdown = 1.");
                    maximalSlowdown = 1;
                    break;
                }
                int calculatedDelay = currentDelay / (maximalSlowdown * 20);
                LOGGER.info("currentDelay: {}, calculatedDelay: {}", (Object)currentDelay, (Object)(calculatedDelay *= maximalSlowdown * 20));
                maximalDeviation = currentDelay - calculatedDelay;
                if (maximalDeviation <= 1000) continue;
                LOGGER.info("The maximal deviation has been exceeded, half the maximalSlowdown and try again.");
                maximalSlowdown /= 2;
                break;
            }
            LOGGER.info("Current maximalDeviation: {}", (Object)maximalDeviation);
        } while (maximalSlowdown != 1 && maximalDeviation > 1000);
        return maximalSlowdown;
    }
}

