/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JPopupMenu;
import javax.swing.event.ListSelectionListener;
import org.bidib.wizard.client.common.view.menu.listener.LabelListMenuListener;
import org.bidib.wizard.mvc.main.view.component.LabeledDisplayItems;
import org.bidib.wizard.mvc.main.view.panel.listener.LabelAction;
import org.bidib.wizard.mvc.main.view.panel.listener.LabelActionListener;
import org.bidib.wizard.mvc.main.view.panel.listener.LabelChangedListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LabelListPanel<T>
implements LabelListMenuListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(LabelListPanel.class);
    private final Collection<LabelChangedListener<T>> labelChangedListeners = new LinkedList();
    private LabeledDisplayItems<T> labelList;
    private LabelAction<T> labelAction;

    public LabelListPanel(LabeledDisplayItems<T> labelList, LabelAction<T> labelAction) {
        LOGGER.info("Create new LabelListPanel with labelList: {}", labelList);
        this.labelList = labelList;
        this.labelAction = labelAction;
    }

    protected LabeledDisplayItems<T> getLabelList() {
        return this.labelList;
    }

    public void addLabelChangedListener(LabelChangedListener<T> l) {
        this.labelChangedListeners.add(l);
    }

    public void addListSelectionListener(ListSelectionListener l) {
        this.labelList.addListSelectionListener(l);
    }

    public void editLabel(MouseEvent popupEvent) {
        Object selectedItem = this.labelList.getSelectedItem();
        if (selectedItem != null) {
            this.labelAction.editLabel(selectedItem, this.selectedIndexToLocation(), (LabelActionListener)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    protected void fireLabelChanged(T object, String label) {
        for (LabelChangedListener l : this.labelChangedListeners) {
            l.labelChanged(object, label);
        }
    }

    protected void handleMouseEvent(MouseEvent e, JPopupMenu popupMenu) {
        if (e.isPopupTrigger() && this.labelList.getItemSize() > 0) {
            this.labelList.selectElement(e.getPoint());
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    protected Point selectedIndexToLocation() {
        int selectedIndex = this.labelList.getSelectedIndex();
        return this.selectedIndexToLocation(selectedIndex);
    }

    private Point selectedIndexToLocation(int selectedIndex) {
        Point result = new Point();
        if (selectedIndex >= 0) {
            Point listPosition = this.labelList.getLocationOnScreen();
            Point itemPosition = this.labelList.indexToLocation(selectedIndex);
            result.setLocation(listPosition.x + itemPosition.x, listPosition.y + itemPosition.y);
        }
        return result;
    }
}

