/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.table;

import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTable;
import org.bidib.wizard.client.common.view.slider.SliderEditor;
import org.bidib.wizard.mvc.common.view.slider.JZeroSlider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MotorSliderEditor
extends SliderEditor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MotorSliderEditor.class);
    private static final long serialVersionUID = 1L;
    private final DecimalFormat format = new DecimalFormat("##0");
    private JButton stopButton;

    public MotorSliderEditor(int minValue, int maxValue, int value) {
        super(minValue, maxValue, value);
    }

    protected void addComponents(JPanel panel, JComponent ... components) {
        panel.add(this.slider);
        panel.add(Box.createHorizontalStrut(2));
        panel.add(this.sliderValue);
        panel.add(Box.createRigidArea(new Dimension(3, 0)));
        this.stopButton = new JButton("STOP");
        this.stopButton.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        panel.add(this.stopButton);
    }

    protected void createJSlider(int minValue, int maxValue, int initialValue) {
        this.slider = new JZeroSlider(minValue, maxValue, initialValue);
    }

    protected void prepareSliderTextLabel(int maxValue, int initialValue) {
        super.prepareSliderTextLabel(maxValue, initialValue);
        this.slider.setOpaque(false);
    }

    protected void updateSliderTextValue(JTable table, int value, boolean isSelected, int row, int column) {
        LOGGER.trace("updateSliderTextValue, value: {}, isSelected: {}", (Object)value, (Object)isSelected);
        String newValue = this.format.format(value);
        LOGGER.trace("Set the new value: {}", (Object)newValue);
        this.sliderValue.setText(newValue);
    }

    public void stop() {
        this.slider.setValue(0);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.stopButton.setEnabled(enabled);
    }

    static /* synthetic */ JSlider access$000(MotorSliderEditor x0) {
        return x0.slider;
    }

    static /* synthetic */ JSlider access$100(MotorSliderEditor x0) {
        return x0.slider;
    }
}

