/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.TicksAware;

public class PortTicksRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    private JPanel comp;
    private JLabel value;
    private int portInstanceColumn;

    public PortTicksRenderer(int portInstanceColumn) {
        this.portInstanceColumn = portInstanceColumn;
        this.comp = new JPanel();
        this.comp.setLayout(new BorderLayout());
        this.value = new JLabel();
        this.value.setMinimumSize(new Dimension(60, 12));
        this.value.setPreferredSize(new Dimension(70, 12));
        this.comp.add((Component)this.value, "East");
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Port port = (Port)table.getModel().getValueAt(row, this.portInstanceColumn);
        Component superComp = super.getTableCellRendererComponent(table, null, isSelected, hasFocus, row, column);
        this.value.setText(null);
        if (port instanceof Port) {
            boolean enabled = port.isEnabled();
            this.setEnabled(enabled);
            this.value.setEnabled(enabled);
            this.setIcon(null);
            if (port instanceof TicksAware) {
                Integer ticks = ((TicksAware)port).getTicks();
                this.setText(ticks != null ? ticks.toString() : null);
                if (ticks != null) {
                    this.value.setText(String.format("(%d ms)", ticks * 20));
                } else {
                    this.value.setText(null);
                }
            }
        } else {
            this.setEnabled(false);
            this.value.setEnabled(false);
            this.setIcon(null);
            this.setText(null);
        }
        ((JComponent)superComp).setOpaque(false);
        this.comp.add(superComp, "Center");
        if (isSelected) {
            this.comp.setBackground(table.getSelectionBackground());
            this.comp.setForeground(table.getSelectionForeground());
            this.value.setForeground(table.getSelectionForeground());
        } else {
            this.comp.setBackground(table.getBackground());
            this.comp.setForeground(table.getForeground());
            this.value.setForeground(table.getForeground());
        }
        return this.comp;
    }
}

