/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.pom.model.command;

import org.bidib.jbidibc.messages.PomAddressData;
import org.bidib.jbidibc.messages.enums.AddressMode;
import org.bidib.jbidibc.messages.enums.PomOperation;
import org.bidib.wizard.mvc.pom.model.AddressProgBeanModel;
import org.bidib.wizard.mvc.pom.model.ProgCommandAwareBeanModel;
import org.bidib.wizard.mvc.pom.model.command.PomAddressValueCommand;
import org.bidib.wizard.mvc.pom.model.command.PomOperationIfElseCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PomAddressValueCommand
extends PomOperationIfElseCommand<AddressProgBeanModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PomAddressValueCommand.class);
    private final ValueType valueType;

    public PomAddressValueCommand(PomAddressData decoderAddress, PomOperation pomOperation, int cvNumber, int cvValue, ValueType valueType) {
        super(decoderAddress, pomOperation, cvNumber, cvValue);
        this.valueType = valueType;
    }

    public void setCvValueResult(Integer cvValueResult) {
        super.setCvValueResult(cvValueResult);
    }

    public void postExecute(AddressProgBeanModel addressProgBeanModel) {
        super.postExecute((ProgCommandAwareBeanModel)addressProgBeanModel);
        LOGGER.debug("PostExecute, cvValueresult: {}", (Object)this.getCvValueResult());
        if (this.getCvValueResult() != null) {
            Integer addressValue = addressProgBeanModel.getAddress();
            int address = addressValue != null ? addressValue : 0;
            int addressPart = this.getCvValueResult();
            AddressMode mode = addressProgBeanModel.getAddressMode();
            LOGGER.debug("Stored address: {}, new addressPart: {}, valueType: {}, mode: {}", new Object[]{address, addressPart, this.valueType, mode});
            address = AddressMode.LONG.equals((Object)mode) ? (ValueType.high.equals((Object)this.valueType) ? (address & 0xFF00) + (addressPart & 0xFF) : (address & 0xFF) + ((addressPart & 0xFF) - 192) * 256) : addressPart & 0xFF;
            LOGGER.debug("Prepared new address: {}", (Object)address);
            addressProgBeanModel.setAddress(Integer.valueOf(address));
        }
    }

    public boolean isExpectedResult() {
        return true;
    }
}

