/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.position.model;

import com.jgoodies.binding.beans.Model;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.bidib.jbidibc.core.schema.bidibbase.BaseLabel;
import org.bidib.jbidibc.messages.enums.PositionLocationEnum;
import org.bidib.wizard.api.model.PositionAddressData;
import org.bidib.wizard.api.model.PositionFeedbackPort;
import org.bidib.wizard.api.model.listener.PortListListener;
import org.bidib.wizard.model.status.FeedbackPortStatus;
import org.bidib.wizard.mvc.position.controller.FeedbackPositionStatusChangeProvider;
import org.bidib.wizard.mvc.position.model.RfBasisNode;
import org.bidib.wizard.mvc.position.model.listener.FeedbackPositionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeedbackPositionModel
extends Model
implements FeedbackPositionStatusChangeProvider {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(FeedbackPositionModel.class);
    public static final String PROPERTY_PORT_LIST = "portList";
    public static final String PROPERTY_RFBASIS_NODES = "rfBasisNodes";
    private PropertyChangeListener pclFeedbackPorts;
    private final List<FeedbackPositionListener> feedbackPositionListeners = new LinkedList();
    private List<PositionFeedbackPort> portList = new LinkedList();
    private final List<PortListListener> portListListeners = new LinkedList();
    private List<RfBasisNode> rfBasisNodes = new LinkedList();
    private long uniqueId;
    private final PropertyChangeListener pclBaseNumber;
    private final IntFunction<BaseLabel> labelFunction;

    public FeedbackPositionModel(IntFunction<BaseLabel> labelFunction) {
        LOGGER.info("Create new instance of FeedbackPositionModel.");
        this.labelFunction = labelFunction;
        this.pclFeedbackPorts = new /* Unavailable Anonymous Inner Class!! */;
        this.addPropertyChangeListener(this.pclFeedbackPorts);
        this.pclBaseNumber = new /* Unavailable Anonymous Inner Class!! */;
    }

    public void setNodeUnique(long uniqueId) {
        LOGGER.info("Set the uniqueId: {}", (Object)uniqueId);
        this.uniqueId = uniqueId;
    }

    private long getUniqueId() {
        return this.uniqueId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPosition(byte[] address, int decoderAddress, PositionLocationEnum locationType, int locationAddress) {
        LOGGER.info("Add position: {}, decoderAddress: {}", (Object)locationAddress, (Object)decoderAddress);
        List list = this.portList;
        synchronized (list) {
            Stream<PositionFeedbackPort> prevPort = this.portList.stream().filter(p -> {
                for (PositionAddressData ad : p.getAddresses()) {
                    if (decoderAddress != ad.getDecoderAddress()) continue;
                    return true;
                }
                return false;
            });
            long lastSeenTimestamp = System.currentTimeMillis();
            PositionAddressData positionAddressData = new PositionAddressData(decoderAddress, lastSeenTimestamp);
            prevPort.iterator().forEachRemaining(p -> {
                p.removeAddress(positionAddressData);
                if (!p.hasAddresses()) {
                    p.setStatus(FeedbackPortStatus.FREE);
                }
            });
            Optional<PositionFeedbackPort> port = this.portList.stream().filter(p -> p.getId() == locationAddress).findFirst();
            if (port.isPresent()) {
                port.get().addAddress(positionAddressData);
                port.get().setStatus(FeedbackPortStatus.OCCUPIED);
            } else {
                PositionFeedbackPort newPort = new PositionFeedbackPort(locationAddress);
                if (this.getUniqueId() > 0L) {
                    try {
                        BaseLabel label = (BaseLabel)this.labelFunction.apply(newPort.getId());
                        LOGGER.info("New port, id: {}, current label: {}", (Object)newPort.getId(), (Object)label);
                        newPort.setLabel(label != null ? label.getLabel() : null);
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Set the label of the feedback position port failed.", (Throwable)ex);
                    }
                } else {
                    LOGGER.info("No feedbackPortLabels or no uniqueId.");
                }
                newPort.addAddress(positionAddressData);
                newPort.setStatus(FeedbackPortStatus.OCCUPIED);
                LOGGER.debug("Created new port to add to portList: {}", (Object)newPort);
                this.portList.add(newPort);
            }
        }
        this.firePropertyChange(PROPERTY_PORT_LIST, null, (Object)this.portList);
    }

    public List<PositionFeedbackPort> getPortList() {
        return this.portList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RfBasisNode> getRfBasisNodes() {
        List list = this.rfBasisNodes;
        synchronized (list) {
            return Collections.unmodifiableList(this.rfBasisNodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRfBasisNodes(List<RfBasisNode> rfBasisNodes) {
        List<RfBasisNode> list = rfBasisNodes;
        synchronized (list) {
            this.rfBasisNodes.clear();
            if (CollectionUtils.isNotEmpty(rfBasisNodes)) {
                this.rfBasisNodes.addAll(rfBasisNodes);
                for (RfBasisNode rfBasisNode : rfBasisNodes) {
                    this.addBaseNumberListener(rfBasisNode);
                }
            }
        }
        this.firePropertyChange(PROPERTY_RFBASIS_NODES, null, (Object)this.rfBasisNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRfBasisNode(RfBasisNode rfBasisNode) {
        List list = this.rfBasisNodes;
        synchronized (list) {
            this.rfBasisNodes.add(rfBasisNode);
            this.addBaseNumberListener(rfBasisNode);
        }
        this.firePropertyChange(PROPERTY_RFBASIS_NODES, null, (Object)this.rfBasisNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRfBasisNode(RfBasisNode rfBasisNode) {
        List list = this.rfBasisNodes;
        synchronized (list) {
            this.rfBasisNodes.remove(rfBasisNode);
            this.removeBaseNumberListener(rfBasisNode);
        }
        this.firePropertyChange(PROPERTY_RFBASIS_NODES, null, (Object)this.rfBasisNodes);
    }

    private void addBaseNumberListener(RfBasisNode rfBasisNode) {
        rfBasisNode.getNode().addPropertyChangeListener("baseNumber", this.pclBaseNumber);
    }

    private void removeBaseNumberListener(RfBasisNode rfBasisNode) {
        rfBasisNode.getNode().removePropertyChangeListener("baseNumber", this.pclBaseNumber);
    }

    public void addFeedbackPortListener(FeedbackPositionListener feedbackPositionListener) {
        this.feedbackPositionListeners.add(feedbackPositionListener);
    }

    public void removeFeedbackPortListener(FeedbackPositionListener feedbackPositionListener) {
        this.feedbackPositionListeners.remove(feedbackPositionListener);
    }

    public void addPortListListener(PortListListener portListListener) {
        this.portListListeners.add(portListListener);
    }

    public void removePortListListener(PortListListener portListListener) {
        this.portListListeners.remove(portListListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAddressesAndPortStatus() {
        List list = this.portList;
        synchronized (list) {
            for (PositionFeedbackPort port : this.portList) {
                port.setStatus(FeedbackPortStatus.FREE);
                port.clear();
            }
        }
        this.firePropertyChange(PROPERTY_PORT_LIST, null, (Object)this.portList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validatePositions(List<PositionFeedbackPort> outdatedPorts, long timeout) {
        List list = this.portList;
        synchronized (list) {
            for (PositionFeedbackPort port : this.portList) {
                boolean outdated;
                if (port.getStatus() != FeedbackPortStatus.OCCUPIED || !(outdated = port.isOutdated(timeout))) continue;
                outdatedPorts.add(port);
            }
        }
    }
}

