/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.preferences.view.panel;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.adapter.ComboBoxAdapter;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.function.Consumer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.converter.StringToIntegerConverter;
import org.bidib.wizard.client.common.preferences.view.panel.AbstractSettingsPanel;
import org.bidib.wizard.client.common.text.InputValidationDocument;
import org.bidib.wizard.client.common.text.IntegerRangeFilter;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.common.model.settings.MiscSettingsInterface;
import org.bidib.wizard.mvc.preferences.model.PreferencesModel;
import org.bidib.wizard.mvc.preferences.view.panel.MiscSettingsPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiscSettingsPanel
extends AbstractSettingsPanel<MiscSettingsInterface> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MiscSettingsPanel.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, fill:50dlu:grow, 3dlu, pref";
    private static final String ENCODED_DIALOG_ROW_SPECS = "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu";
    private final PreferencesModel model;
    private final MiscSettingsInterface miscSettings;
    private JPanel contentPanel;

    public MiscSettingsPanel(PreferencesModel model, MiscSettingsInterface miscSettings, Consumer<Boolean> bufferingCallback) {
        super(bufferingCallback);
        this.model = model;
        this.miscSettings = miscSettings;
    }

    public JPanel createPanel() {
        Object panel;
        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new FormDebugPanel();
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new JPanel(new BorderLayout());
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        dialogBuilder.border((Border)Paddings.TABBED_DIALOG);
        this.preparePresentationModel((Object)this.miscSettings);
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"bidibConfigDir") + ":", new Object[0]).xy(1, 1);
        BufferedValueModel bidibConfigDirModel = this.presentationModel.getBufferedModel("bidibConfigDir");
        JTextField bidibConfigDir = WizardComponentFactory.createTextField((ValueModel)bidibConfigDirModel, (boolean)false);
        dialogBuilder.add((Component)bidibConfigDir).xy(3, 1);
        JButton selectDirectoryButton = new JButton(Resources.getString(MiscSettingsPanel.class, (String)"select-config-directory"));
        selectDirectoryButton.setToolTipText(Resources.getString(MiscSettingsPanel.class, (String)"select-config-directory.tooltip"));
        selectDirectoryButton.addActionListener(evt -> {
            String bidibConfigDirectory = bidibConfigDirModel.getString();
            FileFilter[] ff = null;
            1 dialog = new /* Unavailable Anonymous Inner Class!! */;
            dialog.setApproveButtonText(Resources.getString(MiscSettingsPanel.class, (String)"select-config-directory"));
            dialog.showDialog();
        });
        dialogBuilder.add((Component)selectDirectoryButton).xy(5, 1);
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"logFilePath") + ":", new Object[0]).xy(1, 3);
        BufferedValueModel logFilePathModel = this.presentationModel.getBufferedModel("logFilePath");
        JTextField logFilePath = WizardComponentFactory.createTextField((ValueModel)logFilePathModel, (boolean)false);
        logFilePath.setPreferredSize(new Dimension(300, logFilePath.getPreferredSize().height));
        dialogBuilder.add((Component)logFilePath).xy(3, 3);
        JButton selectLogFilePathButton = new JButton(Resources.getString(MiscSettingsPanel.class, (String)"select-logfile-directory"));
        selectLogFilePathButton.setToolTipText(Resources.getString(MiscSettingsPanel.class, (String)"select-logfile-directory.tooltip"));
        selectLogFilePathButton.addActionListener(evt -> {
            String logFileDirectory = logFilePathModel.getString();
            FileFilter[] ff = null;
            2 dialog = new /* Unavailable Anonymous Inner Class!! */;
            dialog.setApproveButtonText(Resources.getString(MiscSettingsPanel.class, (String)"select-logfile-directory"));
            dialog.showDialog();
        });
        dialogBuilder.add((Component)selectLogFilePathButton).xy(5, 3);
        BufferedValueModel logFileAppendModel = this.presentationModel.getBufferedModel("logFileAppend");
        JCheckBox logFileAppend = WizardComponentFactory.createCheckBox((ValueModel)logFileAppendModel, (String)Resources.getString(this.getClass(), (String)"logFileAppend"));
        logFileAppend.setToolTipText(Resources.getString(this.getClass(), (String)"logFileAppend.tooltip"));
        dialogBuilder.add((Component)logFileAppend).xyw(1, 5, 5);
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"workspacePath") + ":", new Object[0]).xy(1, 7);
        BufferedValueModel workspacePathModel = this.presentationModel.getBufferedModel("workspacePath");
        JTextField workspacePath = WizardComponentFactory.createTextField((ValueModel)workspacePathModel, (boolean)false);
        workspacePath.setPreferredSize(new Dimension(300, workspacePath.getPreferredSize().height));
        dialogBuilder.add((Component)workspacePath).xy(3, 7);
        JButton selectWorkspaceDirectoryButton = new JButton(Resources.getString(MiscSettingsPanel.class, (String)"select-workspace-directory"));
        selectWorkspaceDirectoryButton.setToolTipText(Resources.getString(MiscSettingsPanel.class, (String)"select-workspace-directory.tooltip"));
        selectWorkspaceDirectoryButton.addActionListener(evt -> {
            String workspaceDirectory = workspacePathModel.getString();
            FileFilter[] ff = null;
            3 dialog = new /* Unavailable Anonymous Inner Class!! */;
            dialog.setApproveButtonText(Resources.getString(MiscSettingsPanel.class, (String)"select-workspace-directory"));
            dialog.showDialog();
        });
        dialogBuilder.add((Component)selectWorkspaceDirectoryButton).xy(5, 7);
        BufferedValueModel ignoreWaitTimeoutModel = this.presentationModel.getBufferedModel("ignoreWaitTimeout");
        JCheckBox ignoreWaitTimeout = WizardComponentFactory.createCheckBox((ValueModel)ignoreWaitTimeoutModel, (String)Resources.getString(this.getClass(), (String)"ignoreWaitTimeout"));
        dialogBuilder.add((Component)ignoreWaitTimeout).xyw(1, 9, 5);
        BufferedValueModel ignoreWrongReceiveMessageNumberModel = this.presentationModel.getBufferedModel("ignoreWrongReceiveMessageNumber");
        JCheckBox ignoreWrongReceiveMessageNumber = WizardComponentFactory.createCheckBox((ValueModel)ignoreWrongReceiveMessageNumberModel, (String)Resources.getString(this.getClass(), (String)"ignoreWrongReceiveMessageNumber"));
        dialogBuilder.add((Component)ignoreWrongReceiveMessageNumber).xyw(1, 11, 5);
        ConverterValueModel responseTimeoutConverterModel = new ConverterValueModel((ValueModel)this.presentationModel.getBufferedModel("responseTimeout"), (BindingConverter)new StringToIntegerConverter(Integer.valueOf(400)));
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"responseTimeout") + ":", new Object[0]).xy(1, 13);
        JTextField responseTimeout = new JTextField();
        responseTimeout.setDocument((Document)new InputValidationDocument(4, "0123456789"));
        Bindings.bind((JTextField)responseTimeout, (ValueModel)responseTimeoutConverterModel, (boolean)false);
        dialogBuilder.add((Component)responseTimeout).xy(3, 13);
        ConverterValueModel firmwarePacketTimeoutConverterModel = new ConverterValueModel((ValueModel)this.presentationModel.getBufferedModel("firmwarePacketTimeout"), (BindingConverter)new StringToIntegerConverter(Integer.valueOf(4500)));
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"firmwarePacketTimeout") + ":", new Object[0]).xy(1, 15);
        JTextField firmwarePacketTimeout = new JTextField();
        firmwarePacketTimeout.setDocument((Document)new InputValidationDocument(4, "0123456789"));
        Bindings.bind((JTextField)firmwarePacketTimeout, (ValueModel)firmwarePacketTimeoutConverterModel, (boolean)false);
        dialogBuilder.add((Component)firmwarePacketTimeout).xy(3, 15);
        BufferedValueModel serialUseHardwareFlowControlModel = this.presentationModel.getBufferedModel("serialUseHardwareFlowControl");
        JCheckBox serialUseHardwareFlowControl = WizardComponentFactory.createCheckBox((ValueModel)serialUseHardwareFlowControlModel, (String)Resources.getString(this.getClass(), (String)"serialUseHardwareFlowControl"));
        dialogBuilder.add((Component)serialUseHardwareFlowControl).xyw(1, 17, 5);
        BufferedValueModel selectionHolderSerialProvider = this.presentationModel.getBufferedModel("selectedSerialPortProvider");
        SelectionInList serialProviderSelection = new SelectionInList((ListModel)this.model.getSerialProviderList());
        ComboBoxAdapter comboBoxAdapterSerialProvider = new ComboBoxAdapter((ListModel)serialProviderSelection, (ValueModel)selectionHolderSerialProvider);
        JComboBox comboSerialProvider = new JComboBox();
        comboSerialProvider.setModel(comboBoxAdapterSerialProvider);
        dialogBuilder.add(Resources.getString(MiscSettingsPanel.class, (String)"serialPortProvider") + ":", new Object[0]).xy(1, 19);
        dialogBuilder.add(comboSerialProvider).xy(3, 19);
        ConverterValueModel fetchNodesWorkerThreadPoolSizeConverterModel = new ConverterValueModel((ValueModel)this.presentationModel.getBufferedModel("fetchNodesWorkerThreadPoolSize"), (BindingConverter)new StringToIntegerConverter(Integer.valueOf(60)));
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"fetchNodesWorkerThreadPoolSize") + ":", new Object[0]).xy(1, 21);
        JTextField fetchNodesWorkerThreadPoolSize = new JTextField();
        InputValidationDocument numericDocument = new InputValidationDocument(4, "0123456789");
        numericDocument.setDocumentFilter((DocumentFilter)new IntegerRangeFilter(1, 20));
        fetchNodesWorkerThreadPoolSize.setDocument((Document)numericDocument);
        Bindings.bind((JTextField)fetchNodesWorkerThreadPoolSize, (ValueModel)fetchNodesWorkerThreadPoolSizeConverterModel, (boolean)false);
        dialogBuilder.add((Component)fetchNodesWorkerThreadPoolSize).xy(3, 21);
        ConverterValueModel pingIntervalConverterModel = new ConverterValueModel((ValueModel)this.presentationModel.getBufferedModel("pingInterval"), (BindingConverter)new StringToIntegerConverter(Integer.valueOf(200)));
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"pingInterval") + ":", new Object[0]).xy(1, 23);
        JTextField pingInterval = new JTextField();
        pingInterval.setDocument((Document)new InputValidationDocument(5, "0123456789"));
        Bindings.bind((JTextField)pingInterval, (ValueModel)pingIntervalConverterModel, (boolean)false);
        dialogBuilder.add((Component)pingInterval).xy(3, 23);
        this.contentPanel = dialogBuilder.build();
        this.contentPanel.setOpaque(false);
        return this.contentPanel;
    }
}

