package org.bidib.wizard.mvc.main.view.panel.listener;

import java.util.Map;

import org.bidib.wizard.api.model.NodeInterface;

/**
 * The <code>NodeListActionListener</code> is the listener for actions performed on the node list or node tree.
 */
public interface NodeListActionListener extends LabelChangedListener<NodeInterface> {

    /**
     * Enable delivery of address messages on the node.
     * 
     * @param node
     *            the node
     */
    void enableAddressMessages(final NodeInterface node);

    /**
     * Enable start macros from DCC on the node.
     * 
     * @param node
     *            the node
     */
    void enableDccStart(final NodeInterface node);

    /**
     * Enable start macros from inputs on the node.
     * 
     * @param node
     *            the node
     */
    void enableExternalStart(final NodeInterface node);

    /**
     * Enable delivery of feedback messages on the node.
     * 
     * @param node
     *            the node
     */
    void enableFeedbackMessages(final NodeInterface node);

    /**
     * Disable delivery of feedback mirror on the node.
     * 
     * @param node
     *            the node
     * @param disable
     *            the enable flag
     */
    void disableFeedbackMirror(final NodeInterface node, boolean disable);

    /**
     * Enable delivery of key messages on the node.
     * 
     * @param node
     *            the node
     */
    void enableKeyMessages(final NodeInterface node);

    /**
     * Show the node features dialog.
     * 
     * @param node
     *            the node
     * @param x
     *            the X position of the label component that displays the node
     * @param y
     *            the Y position of the label component that displays the node
     */
    void features(final NodeInterface node, int x, int y);

    /**
     * Export the node configuration to xml file.
     * 
     * @param node
     *            the node
     */
    void exportNode(final NodeInterface node);

    /**
     * Open the firmware update dialog.
     * 
     * @param node
     *            the node
     */
    void firmwareUpdate(final NodeInterface node);

    /**
     * Update the identify state on the node.
     * 
     * @param node
     *            the node
     */
    void identify(final NodeInterface node);

    /**
     * Send a ping to the node.
     * 
     * @param node
     *            the node
     * @param data
     *            the data
     */
    void ping(final NodeInterface node, byte data);

    /**
     * Read the uniqueId from the node.
     * 
     * @param node
     *            the node
     * @return the uniqueId
     */
    Long readUniqueId(final NodeInterface node);

    /**
     * Detach from or attach to the interface node.
     * 
     * @param node
     *            the node
     * @param detach
     *            detach the node flag: {@code true} detach node, {@code false} attach node
     */
    void detachAttachNode(final NodeInterface node, boolean detach);

    /**
     * Import the node configuration from xml file.
     * 
     * @param node
     *            the node
     */
    void importNode(final NodeInterface node);

    /**
     * Open the loco dialog.
     * 
     * @param node
     *            the node
     */
    void loco(final NodeInterface node);

    /**
     * Open the loco table.
     * 
     * @param node
     *            the node
     * @param x
     *            the x position
     * @param y
     *            the y position
     */
    void locoList(final NodeInterface node);

    /**
     * Open the DCC accessory dialog.
     * 
     * @param node
     *            the node
     * @param x
     *            the x position
     * @param y
     *            the y position
     */
    void dccAccessory(final NodeInterface node, int x, int y);

    /**
     * Open the loco CV dialog.
     * 
     * @param node
     *            the node
     * @param x
     *            the x position
     * @param y
     *            the y position
     */
    void locoCv(final NodeInterface node, int x, int y);

    /**
     * Open the loco CV dialog for programming track.
     * 
     * @param node
     *            the node
     * @param x
     *            the x position
     * @param y
     *            the y position
     */
    void locoCvPt(final NodeInterface node, int x, int y);

    /**
     * Show the node details.
     * 
     * @param node
     *            the node
     * @param posX
     *            the X position of the label component that displays the node
     * @param posY
     *            the Y position of the label component that displays the node
     */
    void nodeDetails(final NodeInterface node, int posX, int posY);

    /**
     * Save configurable values (accessories, macros, servo, switch and light port configuration) to the node.
     * 
     * @param node
     *            the node
     * @param params
     *            the parameters
     */
    void saveOnNode(final NodeInterface node, Map<String, Object> params);

    /**
     * Open the DMX modeler.
     * 
     * @param node
     *            the node
     */
    void dmxModeler(final NodeInterface node);

    /**
     * Reset the node.
     * 
     * @param node
     *            the node
     */
    void reset(final NodeInterface node);

    /**
     * Generate documentation of node.
     * 
     * @param node
     *            the node
     */
    void generateDocumentation(final NodeInterface node);

    /**
     * Enable spontaneous events from node.
     * 
     * @param node
     *            the node
     */
    void enableNode(final NodeInterface node);

    /**
     * Disable spontaneous events from node.
     * 
     * @param node
     *            the node
     */
    void disableNode(final NodeInterface node);

    /**
     * Show the bulk switch dialog.
     * 
     * @param node
     *            the node
     * @param posX
     *            the X position of the label component that displays the node
     * @param posY
     *            the Y position of the label component that displays the node
     */
    void bulkSwitchDialog(NodeInterface node, int posX, int posY);

    /**
     * Open the DCCA view.
     * 
     * @param node
     *            the node
     */
    void dccAdvView(final NodeInterface node);

    /**
     * Delete the labels of the node.
     */
    void deleteNodeLabels(final NodeInterface node);

    /**
     * Reload the configuration from the node.
     *
     * @param node
     *            the node
     */
    void reloadNode(final NodeInterface node);

}
