package org.bidib.wizard.mvc.main.view.panel.renderer;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

import org.bidib.jbidibc.messages.enums.IoBehaviourSwitchEnum;
import org.bidib.wizard.api.locale.Resources;

public final class IoBehaviourSwitchCellRenderer implements ListCellRenderer<IoBehaviourSwitchEnum> {
    protected final DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

    private Map<String, String> textMap = new HashMap<>();

    public IoBehaviourSwitchCellRenderer() {

        for (IoBehaviourSwitchEnum loadType : IoBehaviourSwitchEnum.values()) {
            textMap.put(loadType.getKey(), Resources.getString(IoBehaviourSwitchEnum.class, loadType.getKey()));
        }
    }

    @Override
    public Component getListCellRendererComponent(
        JList<? extends IoBehaviourSwitchEnum> list, IoBehaviourSwitchEnum value, int index, boolean isSelected,
        boolean cellHasFocus) {

        JLabel renderer =
            (JLabel) defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);

        if (value != null) {
            renderer.setText(textMap.get(value.getKey()));
        }

        return renderer;
    }
}