package org.bidib.wizard.mvc.main.view.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.model.ports.ConfigurablePort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.client.common.view.renderer.BidibStatusListRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortComboBoxWithButtonRenderer<E extends BidibStatus> extends JPanel implements TableCellRenderer {
    private static final long serialVersionUID = 1L;

    private static final Logger LOGGER = LoggerFactory.getLogger(PortComboBoxWithButtonRenderer.class);

    protected final JComboBox<E> comboBox;

    private final JButton button;

    private final Integer instanceColumn;

    public PortComboBoxWithButtonRenderer(E[] items, String buttonText, Class<?> resourceClazz,
        Integer instanceColumn) {
        this(items, buttonText, Resources.trimWizardPackage(resourceClazz.getName()), instanceColumn);
    }

    public PortComboBoxWithButtonRenderer(E[] items, String buttonText, String resourceClazz, Integer instanceColumn) {
        this.comboBox = new JComboBox<E>(items.clone());
        this.comboBox.setRenderer(new BidibStatusListRenderer<>(resourceClazz));
        this.button = new JButton(buttonText);

        this.instanceColumn = instanceColumn;

        setLayout(new GridBagLayout());

        GridBagConstraints c = new GridBagConstraints();

        c.anchor = GridBagConstraints.FIRST_LINE_START;
        c.fill = GridBagConstraints.BOTH;
        c.gridx = 0;
        c.insets = new Insets(0, 0, 2, 2);
        c.weightx = 1;
        add(comboBox, c);
        c.anchor = GridBagConstraints.FIRST_LINE_END;
        c.gridx++;
        c.weightx = 0;
        add(button, c);
    }

    @Override
    public Component getTableCellRendererComponent(
        JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {

        if (value instanceof ConfigurablePort) {
            ConfigurablePort<?> port = (ConfigurablePort<?>) value;
            boolean isPortEnabled = isPortEnabled(port);
            LOGGER.debug("Port is enabled: {}, port: {}", isPortEnabled, port);
            setEnabled(isPortEnabled);
            comboBox.setEnabled(isPortEnabled);
            button.setEnabled(isPortEnabled);

            setSelectedValue((Port<? extends BidibStatus>) port);
        }
        else if (value instanceof BidibStatus) {
            boolean isPortEnabled = true;
            if (this.instanceColumn != null) {
                ConfigurablePort<?> port =
                    (ConfigurablePort<?>) table.getModel().getValueAt(row, instanceColumn.intValue());
                isPortEnabled = isPortEnabled(port);
            }

            setEnabled(isPortEnabled);
            comboBox.setEnabled(isPortEnabled);
            button.setEnabled(isPortEnabled);

            setSelectedValue((E) value);
        }
        else {
            if (value != null) {
                LOGGER.warn("Invalid value: {}", value);
            }

            setEnabled(false);
            comboBox.setEnabled(false);
            button.setEnabled(false);
        }

        if (isSelected) {
            setForeground(table.getSelectionForeground());
            setBackground(table.getSelectionBackground());

            comboBox.setForeground(table.getSelectionForeground());
            comboBox.setBackground(table.getSelectionBackground());
        }
        else {
            setForeground(table.getForeground());
            setBackground(table.getBackground());

            comboBox.setForeground(table.getForeground());
            comboBox.setBackground(table.getBackground());
        }

        return this;
    }

    protected void setSelectedValue(Port<? extends BidibStatus> port) {
        comboBox.setSelectedItem(port != null ? port.getStatus() : null);
    }

    protected void setSelectedValue(E status) {
        comboBox.setSelectedItem(status);
    }

    protected boolean isPortEnabled(ConfigurablePort<?> port) {
        return port.isEnabled();
    }
}
