package org.bidib.wizard.startup;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(3)
public class WizardStartupParams implements ApplicationRunner {

    private static final Logger LOGGER = LoggerFactory.getLogger(WizardStartupParams.class);

    public static final String MODE_ICONIFIED = "iconified";

    private boolean autoConnect;

    private String startupMode;

    public boolean isAutoConnect() {
        return autoConnect;
    }

    public String getStartupMode() {
        return startupMode;
    }

    @Override
    public void run(ApplicationArguments args) {
        LOGGER.info("Run with args: {}", args);

        List<String> nonOptionArgs = args.getNonOptionArgs();
        if (CollectionUtils.isNotEmpty(nonOptionArgs)) {

            // split the options
            final Map<String, String> options = new HashMap<>();
            for (String option : nonOptionArgs) {

                String[] opt = option.split("=");
                if (opt.length > 1 && opt[0] != null) {
                    options.put(opt[0].toLowerCase(), opt[1]);
                }
            }

            if (options.containsKey("-autoconnect")) {
                try {
                    this.autoConnect = Boolean.valueOf(options.get("-autoconnect"));
                }
                catch (Exception ex) {
                    LOGGER.warn("Get the autoconnect option failed.", ex);
                }
            }

            if (options.containsKey("-startupmode")) {
                try {
                    this.startupMode = options.get("-startupmode");
                }
                catch (Exception ex) {
                    LOGGER.warn("Get the startupmode option failed.", ex);
                }
            }
        }
        LOGGER.info("autoConnect: {}, startupMode: {}", this.autoConnect, this.startupMode);
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
