package org.bidib.wizard.utils;

import org.apache.commons.lang3.SystemUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileUtilsTest {

    @Test
    public void isPathValidTest() {

        if (SystemUtils.IS_OS_WINDOWS) {
            Assertions.assertThat(FileUtils.isPathValid("Test|Name.txt")).isFalse();
        }

        Assertions.assertThat(FileUtils.isPathValid("TestName.txt")).isTrue();
    }

    @Test
    public void escapeInvalidFilenameCharactersTest() {

        Assertions
            .assertThat(FileUtils.escapeInvalidFilenameCharacters("Test_Name.txt", "_")).isEqualTo("Test_Name.txt");

        Assertions
            .assertThat(FileUtils.escapeInvalidFilenameCharacters("Test|Name.txt", "_")).isEqualTo("Test_Name.txt");

        Assertions.assertThat(FileUtils.escapeInvalidFilenameCharacters("TestName.txt", "_")).isEqualTo("TestName.txt");
    }
}
