/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.dialog;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.text.JHyperlink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AboutDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(AboutDialog.class);
    private final Properties version = new Properties();

    public AboutDialog(Component parentComponent) throws IOException {
        try {
            this.version.load(this.getClass().getResourceAsStream("/META-INF/build-info.properties"));
        }
        catch (Exception ex) {
            LOGGER.warn("Load build info failed.", (Throwable)ex);
        }
        JOptionPane pane = new JOptionPane(this.getPanel(), 1);
        JDialog dialog = pane.createDialog(parentComponent, Resources.getString(this.getClass(), (String)"title") + " " + this.version.getProperty("build.name"));
        dialog.setVisible(true);
    }

    private JPanel getPanel() throws IOException {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 0;
        c.gridwidth = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(5, 5, 5, 5);
        result.add((Component)new JLabel(this.version.getProperty("build.name")), c);
        c.gridwidth = 1;
        ++c.gridy;
        result.add((Component)new JSeparator(0), c);
        ++c.gridy;
        result.add((Component)new JLabel(Resources.getString(this.getClass(), (String)"authors") + ":"), c);
        String authorsText = "<html>" + Stream.of(this.version.getProperty("build.projectauthor").split(";")).collect(Collectors.joining("<br/>")) + "</html>";
        JLabel authors = new JLabel(authorsText);
        ++c.gridx;
        result.add((Component)authors, c);
        c.gridx = 0;
        ++c.gridy;
        result.add((Component)new JLabel(Resources.getString(this.getClass(), (String)"version") + ":"), c);
        ++c.gridx;
        result.add((Component)new JLabel(this.version.getProperty("build.version")), c);
        c.gridx = 0;
        ++c.gridy;
        result.add((Component)new JLabel(Resources.getString(this.getClass(), (String)"build") + ":"), c);
        ++c.gridx;
        result.add((Component)new JLabel(this.version.getProperty("build.buildnumber-and-branch-info")), c);
        c.gridx = 0;
        ++c.gridy;
        result.add((Component)new JLabel(Resources.getString(this.getClass(), (String)"date") + ":"), c);
        ++c.gridx;
        LocalDateTime parsed = LocalDateTime.parse(this.version.getProperty("build.time"), DateTimeFormatter.ISO_DATE_TIME);
        result.add((Component)new JLabel(parsed.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))), c);
        c.gridx = 0;
        ++c.gridy;
        result.add((Component)new JLabel(Resources.getString(this.getClass(), (String)"java") + ":"), c);
        ++c.gridx;
        result.add((Component)new JLabel(System.getProperty("java.version")), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        JHyperlink famfamfamHyperLink = new JHyperlink();
        famfamfamHyperLink.setURL("http://www.famfamfam.com/lab/icons/silk/");
        famfamfamHyperLink.setText("Icons provided by http://www.famfamfam.com/lab/icons/silk/");
        result.add((Component)famfamfamHyperLink, c);
        ++c.gridy;
        c.gridwidth = 2;
        JHyperlink jideHyperLink = new JHyperlink();
        jideHyperLink.setURL("http://www.jidesoft.com");
        jideHyperLink.setText("Free JIDE license for open source project by http://www.jidesoft.com");
        result.add((Component)jideHyperLink, c);
        ++c.gridy;
        c.gridwidth = 2;
        result.add((Component)new JLabel("<html>Images provided by:<br/>OpenDCC, Martin Welzel, Andreas Tillner"), c);
        ++c.gridy;
        result.add((Component)new JLabel("<html>NL translation: Bert van der Lugt Melsert"), c);
        ++c.gridy;
        c.gridwidth = 2;
        JHyperlink freeEmojiIconsLink = new JHyperlink();
        freeEmojiIconsLink.setURL("https://www.emojione.com/");
        freeEmojiIconsLink.setText("Thanks to EmojiOne for providing free emoji icons");
        result.add((Component)freeEmojiIconsLink, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.insets = new Insets(5, 5, 5, 0);
        JHyperlink freePikLink = new JHyperlink();
        freePikLink.setURL("https://www.freepik.com");
        freePikLink.setText("Icons made by Freepik");
        result.add((Component)freePikLink, c);
        JHyperlink flaticonLink = new JHyperlink();
        flaticonLink.setURL("https://www.flaticon.com/");
        flaticonLink.setText("from www.flaticon.com");
        ++c.gridx;
        result.add((Component)flaticonLink, c);
        return result;
    }
}

