/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.booster.view;

import com.jgoodies.binding.adapter.AbstractTableAdapter;
import com.jgoodies.binding.list.SelectionInList;
import org.bidib.jbidibc.messages.enums.BoosterControl;
import org.bidib.jbidibc.messages.enums.BoosterState;
import org.bidib.jbidibc.messages.enums.CommandStationState;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.mvc.booster.model.BoosterModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoosterTableTableModel
extends AbstractTableAdapter<BoosterModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoosterTableTableModel.class);
    private static final long serialVersionUID = 1L;
    public static final int COLUMN_UNIQUE_ID = 0;
    public static final int COLUMN_DESCRIPTION = 1;
    public static final int COLUMN_STATUS = 2;
    public static final int COLUMN_CS_STATUS = 3;
    public static final int COLUMN_TEMPERATURE = 4;
    public static final int COLUMN_VOLTAGE = 5;
    public static final int COLUMN_MAX_CURRENT = 6;
    public static final int COLUMN_CURRENT = 7;
    public static final int COLUMN_CONTROL = 8;
    public static final int COLUMN_PORT_INSTANCE = 9;
    private static final String[] COLUMNNAMES = new String[]{Resources.getString(BoosterTableTableModel.class, (String)"uniqueId"), Resources.getString(BoosterTableTableModel.class, (String)"description"), Resources.getString(BoosterTableTableModel.class, (String)"status"), Resources.getString(BoosterTableTableModel.class, (String)"csStatus"), Resources.getString(BoosterTableTableModel.class, (String)"temperature"), Resources.getString(BoosterTableTableModel.class, (String)"voltage"), Resources.getString(BoosterTableTableModel.class, (String)"maxCurrent"), Resources.getString(BoosterTableTableModel.class, (String)"current"), Resources.getString(BoosterTableTableModel.class, (String)"control")};

    public BoosterTableTableModel(SelectionInList<BoosterModel> boosterList) {
        super(boosterList, COLUMNNAMES);
        LOGGER.info("Current listModel: {}", (Object)this.getListModel());
    }

    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 2: {
                return BoosterState.class;
            }
            case 3: {
                return CommandStationState.class;
            }
            case 8: {
                return BoosterControl.class;
            }
        }
        return Object.class;
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        BoosterModel booster = (BoosterModel)this.getRow(rowIndex);
        switch (columnIndex) {
            case 0: {
                return booster.getUniqueId();
            }
            case 1: {
                return booster.getNodeLabel();
            }
            case 2: {
                return booster.getState();
            }
            case 3: {
                return booster.getCommandStationState();
            }
            case 4: {
                if (ProductUtils.isRFBasisNode((long)booster.getBooster().getUniqueId()) || ProductUtils.isIF2((long)booster.getBooster().getUniqueId())) {
                    return null;
                }
                return booster.getTemperature();
            }
            case 5: {
                if (ProductUtils.isRFBasisNode((long)booster.getBooster().getUniqueId()) || ProductUtils.isIF2((long)booster.getBooster().getUniqueId())) {
                    return null;
                }
                return booster.getVoltage();
            }
            case 6: {
                return booster.getMaxCurrent();
            }
            case 7: {
                return booster.getCurrent();
            }
            case 8: {
                return booster.getBoosterControl();
            }
        }
        return null;
    }
}

