/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.common.view.editor;

import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import org.apache.commons.lang3.StringUtils;
import org.bidib.wizard.client.common.text.InputValidationDocument;
import org.bidib.wizard.client.common.text.IntegerRangeFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberRangeEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(NumberRangeEditor.class);
    protected final JTextField textField = new JTextField();

    public NumberRangeEditor(int minimum, int maximum) {
        this.textField.setHorizontalAlignment(4);
        InputValidationDocument numericDocument = new InputValidationDocument(8, "0123456789");
        numericDocument.setDocumentFilter((DocumentFilter)new IntegerRangeFilter(minimum, maximum));
        this.textField.setDocument((Document)numericDocument);
        this.textField.setColumns(4);
    }

    public NumberRangeEditor() {
        this(0, 255);
    }

    @Override
    public Object getCellEditorValue() {
        try {
            if (StringUtils.isNotBlank((CharSequence)this.textField.getText())) {
                return Integer.parseInt(this.textField.getText());
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Parse textfield value failed.", (Throwable)ex);
        }
        return 0;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.textField.setText(value != null ? value.toString() : "");
        return this.textField;
    }

    @Override
    public boolean stopCellEditing() {
        try {
            if (StringUtils.isNotBlank((CharSequence)this.textField.getText())) {
                int value = Integer.valueOf(this.textField.getText());
                LOGGER.debug("Current value: {}", (Object)value);
            } else {
                LOGGER.info("Allow empty string in text field.");
            }
        }
        catch (Exception e) {
            LOGGER.warn("Parse text value failed: {}", (Object)e.getMessage());
            return false;
        }
        return super.stopCellEditing();
    }
}

