/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.common.view.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.bidib.wizard.mvc.common.view.table.IconTableCellRenderer;

public class IconTableCellRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;
    Icon defaultIcon;
    static AbstractButton button = new /* Unavailable Anonymous Inner Class!! */;

    public IconTableCellRenderer() {
    }

    public IconTableCellRenderer(Icon defaultIcon) {
        this.defaultIcon = defaultIcon;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Icon icon = (Icon)value;
        this.setIcon(null);
        this.setText("width=" + icon.getIconWidth() + ", height=" + icon.getIconHeight());
        this.setBackground(this.getCorrectBackground(table, isSelected));
        try {
            this.createIcon(icon, (JComponent)this);
        }
        catch (ClassCastException cce) {
            try {
                String className = cce.getMessage();
                className = className.substring(className.lastIndexOf(" ") + 1);
                Class<?> clazz = Class.forName(className);
                this.createIcon(icon, (JComponent)clazz.newInstance());
            }
            catch (InstantiationException ie) {
                try {
                    this.createIcon(icon, (JComponent)button);
                }
                catch (Exception exception) {
                }
            }
            catch (Exception exception) {}
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        if (this.getIcon() == null) {
            try {
                this.createIcon((Icon)(this.defaultIcon == null ? new XIcon(this, icon.getIconWidth(), icon.getIconHeight()) : this.defaultIcon), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setBackground(this.getCorrectBackground(table, isSelected));
        return this;
    }

    private void createIcon(Icon icon, JComponent component) throws ClassCastException, InstantiationException {
        BufferedImage image = new BufferedImage(icon.getIconWidth() + 2, icon.getIconHeight() + 2, 2);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(component, g, 2, 2);
        this.setIcon((Icon)new ImageIcon(image));
    }

    private Color getCorrectBackground(JTable table, boolean isSelected) {
        return isSelected ? table.getSelectionBackground() : table.getBackground();
    }

    public static void setRowHeightsForIcons(JTable table) {
        TableModel model = table.getModel();
        for (int col = 0; col < table.getColumnCount(); ++col) {
            if (!Icon.class.isAssignableFrom(table.getColumnClass(col)) || !(table.getDefaultRenderer(Icon.class) instanceof IconTableCellRenderer)) continue;
            for (int row = 0; row < model.getRowCount(); ++row) {
                Icon icon = (Icon)model.getValueAt(row, col);
                table.setRowHeight(table.convertRowIndexToView(row), Math.max(table.getRowHeight(row), icon.getIconHeight() + 2));
            }
        }
    }

    static {
        button.setModel(new DefaultButtonModel());
    }
}

