/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.dmx.model;

import com.jgoodies.binding.beans.Model;
import java.awt.Color;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.bidib.jbidibc.exchange.dmxscenery.BacklightPortType;
import org.bidib.jbidibc.exchange.dmxscenery.ColorType;
import org.bidib.jbidibc.exchange.dmxscenery.DmxChannelType;
import org.bidib.jbidibc.exchange.dmxscenery.DmxSceneryPointType;
import org.bidib.jbidibc.exchange.dmxscenery.DmxSceneryPointsType;
import org.bidib.jbidibc.exchange.dmxscenery.DmxSceneryType;
import org.bidib.jbidibc.exchange.dmxscenery.LightPortType;
import org.bidib.jbidibc.exchange.dmxscenery.LineColorUtils;
import org.bidib.jbidibc.exchange.dmxscenery.PortType;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.CollectionUtils;
import org.bidib.wizard.api.model.function.MacroFunction;
import org.bidib.wizard.api.utils.PortUtils;
import org.bidib.wizard.model.ports.BacklightPort;
import org.bidib.wizard.model.ports.DmxChannel;
import org.bidib.wizard.model.ports.DmxLightPort;
import org.bidib.wizard.model.ports.LightPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.mvc.dmx.model.DmxEnvironmentProvider;
import org.bidib.wizard.mvc.dmx.model.DmxSceneryPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmxScenery
extends Model {
    private static final Logger LOGGER = LoggerFactory.getLogger(DmxScenery.class);
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_MACRO_NUMBER = "macroNumber";
    public static final String PROPERTY_DIMM_STRETCH = "dimmStretch";
    public static final String PROPERTY_USED_CHANNELS = "usedChannels";
    private final String id;
    private String name;
    private List<DmxChannel> usedChannels = new LinkedList();
    private List<DmxSceneryPoint> sceneryPoints = new LinkedList();
    private Integer macroNumber;

    public DmxScenery(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldValue = this.name;
        this.name = name;
        this.firePropertyChange(PROPERTY_NAME, (Object)oldValue, (Object)name);
    }

    public List<DmxChannel> getUsedChannels() {
        return this.usedChannels;
    }

    public void setUsedChannels(List<DmxChannel> usedChannels) {
        List oldValue = this.usedChannels;
        this.usedChannels = usedChannels;
        this.firePropertyChange(PROPERTY_USED_CHANNELS, (Object)oldValue, (Object)this.usedChannels);
    }

    public void addUsedChannels(List<DmxChannel> usedChannels) {
        List oldValue = this.usedChannels;
        LinkedList<DmxChannel> newUsedChannels = new LinkedList<DmxChannel>(oldValue);
        newUsedChannels.addAll(usedChannels);
        this.usedChannels = newUsedChannels;
        this.firePropertyChange(PROPERTY_USED_CHANNELS, (Object)oldValue, (Object)this.usedChannels);
    }

    public void addUsedChannel(DmxChannel usedChannel) {
        List oldValue = this.usedChannels;
        LinkedList<DmxChannel> newUsedChannels = new LinkedList<DmxChannel>(oldValue);
        newUsedChannels.add(usedChannel);
        this.usedChannels = newUsedChannels;
        this.firePropertyChange(PROPERTY_USED_CHANNELS, (Object)oldValue, (Object)this.usedChannels);
    }

    public void removeUsedChannel(DmxChannel usedChannel) {
        List oldValue = this.usedChannels;
        LinkedList newUsedChannels = new LinkedList(oldValue);
        newUsedChannels.remove(usedChannel);
        this.usedChannels = newUsedChannels;
        this.firePropertyChange(PROPERTY_USED_CHANNELS, (Object)oldValue, (Object)this.usedChannels);
    }

    public List<DmxSceneryPoint> getSceneryPoints() {
        return this.sceneryPoints;
    }

    public void setSceneryPoints(List<DmxSceneryPoint> sceneryPoints) {
        this.sceneryPoints = sceneryPoints;
    }

    public Integer getMacroNumber() {
        return this.macroNumber;
    }

    public void setMacroNumber(Integer macroNumber) {
        Integer oldValue = this.macroNumber;
        this.macroNumber = macroNumber;
        this.firePropertyChange(PROPERTY_MACRO_NUMBER, (Object)oldValue, (Object)this.macroNumber);
    }

    public String toString() {
        return this.name;
    }

    public DmxScenery withDmxScenery(DmxEnvironmentProvider dmxEnvironmentProvider, DmxSceneryType dmxScenery) {
        this.setName(dmxScenery.getSceneryName());
        this.setMacroNumber(dmxScenery.getMacroNumber());
        if (CollectionUtils.hasElements((Collection)dmxScenery.getDmxChannel())) {
            LinkedList<DmxChannel> dmxChannels = new LinkedList<DmxChannel>();
            for (DmxChannelType dmxChannelType : dmxScenery.getDmxChannel()) {
                int channelNumber = dmxChannelType.getChannelNumber();
                int index = dmxEnvironmentProvider.getDmxChannels().indexOf(new DmxChannel(channelNumber));
                if (index > -1) {
                    DmxChannel dmxChannel = (DmxChannel)dmxEnvironmentProvider.getDmxChannels().get(index);
                    this.withDmxChannel(dmxChannel, dmxEnvironmentProvider, dmxChannelType);
                    dmxChannels.add(dmxChannel);
                    continue;
                }
                LOGGER.warn("No DMX channel found in system with channel number: {}", (Object)channelNumber);
            }
            this.addUsedChannels(dmxChannels);
        }
        if (dmxScenery.getDmxSceneryPoints() != null) {
            for (DmxSceneryPointType dmxSceneryPointType : dmxScenery.getDmxSceneryPoints().getDmxSceneryPoint()) {
                DmxSceneryPoint dmxSceneryPoint = new DmxSceneryPoint().withTimeOffset(dmxSceneryPointType.getTimeOffset()).withBrightness(dmxSceneryPointType.getBrightness()).withUniqueId(dmxSceneryPointType.getUniqueId()).withDmxChannelNumber(dmxSceneryPointType.getDmxChannelNumber());
                if (dmxSceneryPointType.getMacroNumber() != null) {
                    MacroFunction macro = new MacroFunction();
                    macro.setMacroId(dmxSceneryPointType.getMacroNumber().intValue());
                    dmxSceneryPoint.setMacro(macro);
                }
                if (dmxSceneryPointType.getPort() != null) {
                    dmxSceneryPoint.withPort(this.fromPortType(dmxEnvironmentProvider, dmxSceneryPointType.getPort()));
                    dmxSceneryPoint.withAction(PortUtils.actionFromPortType((PortType)dmxSceneryPointType.getPort(), (Integer)dmxSceneryPointType.getBidibAction()));
                }
                this.sceneryPoints.add(dmxSceneryPoint);
            }
        }
        return this;
    }

    public DmxChannel withDmxChannel(DmxChannel dmxChannel, DmxEnvironmentProvider dmxEnvironmentProvider, DmxChannelType dmxChannelType) {
        dmxChannel.setLineColor(LineColorUtils.getColor((ColorType)dmxChannelType.getLineColor()));
        int dmxTargetChannel = dmxChannelType.getChannelNumber();
        if (CollectionUtils.hasElements((Collection)dmxChannelType.getPort())) {
            LinkedList<Object> ports = new LinkedList<Object>();
            block0: for (PortType portType : dmxChannelType.getPort()) {
                int portNum;
                LOGGER.info("Current port: {}", (Object)portType);
                if (portType instanceof BacklightPortType) {
                    portNum = portType.getPortNumber();
                    for (BacklightPort port : dmxEnvironmentProvider.getBacklightPorts()) {
                        if (port.getId() != portNum) continue;
                        ports.add(port);
                        continue block0;
                    }
                    continue;
                }
                if (portType instanceof LightPortType) {
                    portNum = portType.getPortNumber();
                    for (BacklightPort port : dmxEnvironmentProvider.getLightPorts()) {
                        if (port.getId() != portNum) continue;
                        ports.add(port);
                        continue block0;
                    }
                    continue;
                }
                LOGGER.warn("Unsupported port type detected: {}", (Object)portType);
            }
            boolean autoAddPorts = false;
            if (autoAddPorts) {
                for (DmxLightPort dmxLightPort : dmxEnvironmentProvider.getLightPorts()) {
                    if (dmxLightPort.getDmxTargetChannel() == null || dmxLightPort.getDmxTargetChannel().getChannelId() != dmxTargetChannel || ports.contains(dmxLightPort)) continue;
                    LOGGER.info("Add new dmxLightPort that is configured in the OneDMX: {}", (Object)dmxLightPort);
                    ports.add(dmxLightPort);
                }
                for (BacklightPort backlightPort : dmxEnvironmentProvider.getBacklightPorts()) {
                    if (backlightPort.getDmxMapping() != dmxTargetChannel || ports.contains(backlightPort)) continue;
                    LOGGER.info("Add new backlightPort that is configured in the OneDMX: {}", (Object)backlightPort);
                    ports.add(backlightPort);
                }
            }
            LOGGER.info("Set the assigned ports: {}", ports);
            dmxChannel.setAssignedPorts(ports);
        }
        return dmxChannel;
    }

    private Port<?> fromPortType(DmxEnvironmentProvider dmxEnvironmentProvider, PortType portType) {
        if (portType != null) {
            int portNumber = portType.getPortNumber();
            if (portType instanceof LightPortType) {
                for (DmxLightPort lightPort : dmxEnvironmentProvider.getLightPorts()) {
                    if (lightPort.getId() != portNumber) continue;
                    return lightPort;
                }
            } else if (portType instanceof BacklightPortType) {
                for (BacklightPort backlightPort : dmxEnvironmentProvider.getBacklightPorts()) {
                    if (backlightPort.getId() != portNumber) continue;
                    return backlightPort;
                }
            }
        }
        LOGGER.warn("No port found for portType: {}", (Object)portType);
        return null;
    }

    private PortType fromPort(Port<?> port) {
        BacklightPortType portType = null;
        if (port instanceof DmxLightPort) {
            LightPort lightPort = ((DmxLightPort)port).getLightPort();
            portType = new LightPortType().withPortNumber(lightPort.getId());
        } else if (port instanceof BacklightPort) {
            portType = new BacklightPortType().withPortNumber(port.getId());
        } else {
            LOGGER.warn("Unsupported port detected: {}", port);
        }
        return portType;
    }

    public DmxSceneryType fromDmxScenery() {
        DmxSceneryType dmxSceneryType = new DmxSceneryType().withSceneryName(this.getName()).withMacroNumber(this.getMacroNumber());
        for (DmxChannel dmxChannel : this.getUsedChannels()) {
            DmxChannelType dmxChannelType = new DmxChannelType().withChannelName(dmxChannel.toString()).withChannelNumber(dmxChannel.getChannelId()).withLineColor(LineColorUtils.getColorType((Color)dmxChannel.getLineColor()));
            for (Port port : dmxChannel.getAssignedPorts()) {
                PortType portType = this.fromPort(port);
                if (portType == null) continue;
                dmxChannelType.getPort().add(portType);
            }
            dmxSceneryType.getDmxChannel().add(dmxChannelType);
        }
        if (CollectionUtils.hasElements((Collection)this.sceneryPoints)) {
            DmxSceneryPointsType dmxSceneryPoints = new DmxSceneryPointsType();
            for (DmxSceneryPoint dmxSceneryPoint : this.sceneryPoints) {
                PortType portType = this.fromPort(dmxSceneryPoint.getPort());
                DmxSceneryPointType dmxSceneryPointType = new DmxSceneryPointType().withTimeOffset(dmxSceneryPoint.getTimeOffset()).withDmxChannelNumber(dmxSceneryPoint.getDmxChannelNumber()).withBrightness(dmxSceneryPoint.getBrightness()).withUniqueId(dmxSceneryPoint.getUniqueId());
                if (portType != null) {
                    dmxSceneryPointType.withPort(portType);
                    if (dmxSceneryPoint.getAction() != null) {
                        dmxSceneryPointType.withBidibAction(Integer.valueOf(ByteUtils.getInt((byte)dmxSceneryPoint.getAction().getType().getType())));
                    }
                } else if (dmxSceneryPoint.getMacro() != null) {
                    dmxSceneryPointType.withMacroNumber(Integer.valueOf(dmxSceneryPoint.getMacro().getMacroId()));
                } else {
                    LOGGER.warn("Incomplete scenery point without port assigned is stored.");
                }
                dmxSceneryPoints.getDmxSceneryPoint().add(dmxSceneryPointType);
            }
            dmxSceneryType.setDmxSceneryPoints(dmxSceneryPoints);
        }
        return dmxSceneryType;
    }
}

