/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.dmx.view.panel;

import java.awt.Point;
import java.awt.event.ActionEvent;
import org.bidib.wizard.model.ports.DmxChannel;
import org.bidib.wizard.model.status.MacroStatus;
import org.bidib.wizard.mvc.dmx.view.panel.DmxChartPanel;
import org.bidib.wizard.mvc.dmx.view.panel.DmxDataItem;
import org.bidib.wizard.mvc.dmx.view.panel.LocationAwareAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroStatusAction
extends LocationAwareAction<DmxChannel> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MacroStatusAction.class);
    private MacroStatus macroStatus;
    private DmxChannel dmxChannel;
    private DmxDataItem originalDataItem;

    public MacroStatusAction(MacroStatus macroStatus, DmxChannel dmxChannel, DmxChartPanel dmxChartPanel, DmxDataItem originalDataItem) {
        super(macroStatus.toString(), (Object)dmxChannel, dmxChartPanel);
        this.dmxChannel = dmxChannel;
        this.macroStatus = macroStatus;
        this.originalDataItem = originalDataItem;
    }

    public void actionPerformed(ActionEvent event) {
        Point currentMousePoint = this.dmxChartPanel.getCurrentMousePoint();
        String seriesKey = Integer.toString(this.dmxChannel.getChannelId());
        LOGGER.info("Selected key: {}, currentMousePoint: {}", (Object)seriesKey, (Object)currentMousePoint);
        if (this.originalDataItem != null) {
            LOGGER.info("Set action on port for item: {}, lightPortStatus: {}", (Object)this.originalDataItem, (Object)this.macroStatus);
            this.dmxChartPanel.setMacroStatusAction(seriesKey, this.originalDataItem, this.macroStatus);
        }
    }
}

