/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.features.view.panel;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.text.Document;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.enums.FeatureEnum;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.wizard.client.common.view.validation.IntegerInputValidationDocument;
import org.bidib.wizard.client.common.view.validation.RangeValidationCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureAwareEditor
extends AbstractCellEditor
implements TableCellEditor,
RangeValidationCallback {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureAwareEditor.class);
    private final JTextField textField = new JTextField();
    private int clickCountToStart = 2;
    private FeatureEnum editedFeature;

    public FeatureAwareEditor() {
        IntegerInputValidationDocument doc = new IntegerInputValidationDocument(3, "0123456789");
        doc.setRangeValidationCallback((RangeValidationCallback)this);
        this.textField.setDocument((Document)doc);
    }

    public void setClickCountToStart(int count) {
        this.clickCountToStart = count;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= this.clickCountToStart;
        }
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        return this.textField.getText();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.textField.setText(null);
        this.textField.setToolTipText(null);
        this.editedFeature = null;
        if (value instanceof Feature) {
            Feature feature = (Feature)value;
            this.editedFeature = FeatureEnum.valueOf((byte)ByteUtils.getLowByte((int)feature.getType()));
            int featureValue = feature.getValue();
            this.textField.setText(Integer.toString(featureValue));
        } else {
            LOGGER.warn("Provided value is not a feature: {}", value);
        }
        return this.textField;
    }

    public int getMinValue() {
        Integer minValue;
        if (this.editedFeature != null && (minValue = this.editedFeature.getMin()) != null) {
            return minValue;
        }
        return 0;
    }

    public int getMaxValue() {
        Integer maxValue;
        if (this.editedFeature != null && (maxValue = this.editedFeature.getMax()) != null) {
            return maxValue;
        }
        return 255;
    }
}

