/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.locolist.view;

import com.jgoodies.binding.adapter.AbstractTableAdapter;
import com.jgoodies.binding.list.SelectionInList;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.model.status.DirectionStatus;
import org.bidib.wizard.model.status.SpeedSteps;
import org.bidib.wizard.mvc.locolist.model.LocoModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocoTableTableModel
extends AbstractTableAdapter<LocoModel> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocoTableTableModel.class);
    private static final long serialVersionUID = 1L;
    public static final int COLUMN_ADDRESS = 0;
    public static final int COLUMN_SPEED = 1;
    public static final int COLUMN_DIRECTION = 2;
    public static final int COLUMN_SPEEDSTEPS = 3;
    public static final int COLUMN_FUNCTIONS_LIGHT = 4;
    public static final int COLUMN_FUNCTIONS_1_TO_4 = 5;
    public static final int COLUMN_FUNCTIONS_5_TO_12 = 6;
    public static final int COLUMN_FUNCTIONS_13_TO_20 = 7;
    public static final int COLUMN_FUNCTIONS_21_TO_28 = 8;
    public static final int COLUMN_PORT_INSTANCE = 9;
    private static final String[] COLUMNNAMES = new String[]{Resources.getString(LocoTableTableModel.class, (String)"address"), Resources.getString(LocoTableTableModel.class, (String)"speed"), Resources.getString(LocoTableTableModel.class, (String)"direction"), Resources.getString(LocoTableTableModel.class, (String)"speedSteps"), Resources.getString(LocoTableTableModel.class, (String)"functionsLight"), Resources.getString(LocoTableTableModel.class, (String)"functions1To4"), Resources.getString(LocoTableTableModel.class, (String)"functions5To12"), Resources.getString(LocoTableTableModel.class, (String)"functions13To20"), Resources.getString(LocoTableTableModel.class, (String)"functions21To28")};

    public LocoTableTableModel(SelectionInList<LocoModel> boosterList) {
        super(boosterList, COLUMNNAMES);
        LOGGER.info("Current listModel: {}", (Object)this.getListModel());
    }

    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return Integer.class;
            }
            case 2: {
                return Boolean.class;
            }
            case 3: {
                return SpeedSteps.class;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return Integer.class;
            }
        }
        return Object.class;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        LocoModel loco = (LocoModel)this.getRow(rowIndex);
        switch (columnIndex) {
            case 0: {
                return loco.getLocoAddress();
            }
            case 1: {
                return loco.getSpeed() * (loco.getDirection() == DirectionStatus.FORWARD ? 1 : -1);
            }
            case 2: {
                return loco.getDirection() == DirectionStatus.FORWARD ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return loco.getSpeedSteps();
            }
            case 4: {
                return loco.getFunctions(0) & 0x10;
            }
            case 5: {
                return loco.getFunctions(0) & 0xF;
            }
            case 6: {
                return loco.getFunctions(1) & 0xFF;
            }
            case 7: {
                return loco.getFunctions(2) & 0xFF;
            }
            case 8: {
                return loco.getFunctions(3) & 0xFF;
            }
        }
        return null;
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }
}

