/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.controller;

import io.reactivex.rxjava3.subjects.PublishSubject;
import javax.swing.SwingUtilities;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.wizard.api.model.listener.PortListener;
import org.bidib.wizard.api.service.node.SwitchingNodeService;
import org.bidib.wizard.client.common.model.listener.PortModelListener;
import org.bidib.wizard.common.labels.LabelsChangedEvent;
import org.bidib.wizard.common.labels.WizardLabelFactory;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.model.ports.event.PortConfigChangeEvent;
import org.bidib.wizard.mvc.main.model.BacklightPortTableModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.BacklightPortListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.TabVisibilityListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;

public class BacklightPortPanelController {
    private static final Logger LOGGER = LoggerFactory.getLogger(BacklightPortPanelController.class);
    private final MainModel mainModel;
    @Autowired
    private SwitchingNodeService switchingNodeService;
    @Autowired
    private WizardLabelWrapper wizardLabelWrapper;
    private BacklightPortListPanel backlightPortListPanel;
    private final PublishSubject<PortConfigChangeEvent> portConfigChangeEventSubject = PublishSubject.create();

    public BacklightPortPanelController(MainModel mainModel) {
        this.mainModel = mainModel;
    }

    public BacklightPortListPanel createPanel(TabVisibilityListener tabVisibilityListener) {
        BacklightPortTableModel tableModel = new BacklightPortTableModel();
        tableModel.setPortListener((PortModelListener)new /* Unavailable Anonymous Inner Class!! */);
        this.backlightPortListPanel = new BacklightPortListPanel(this, tableModel, this.mainModel, tabVisibilityListener, this.portConfigChangeEventSubject);
        this.backlightPortListPanel.setPortListener((PortListener)new /* Unavailable Anonymous Inner Class!! */);
        return this.backlightPortListPanel;
    }

    private NodeLabels getNodeLabels() {
        WizardLabelFactory wizardLabelFactory = this.wizardLabelWrapper.getWizardLabelFactory();
        NodeLabels nodeLabels = wizardLabelFactory.loadLabels(Long.valueOf(this.mainModel.getSelectedNode().getUniqueId()), new String[0]);
        return nodeLabels;
    }

    private void saveLabels() {
        try {
            long uniqueId = this.mainModel.getSelectedNode().getUniqueId();
            this.wizardLabelWrapper.saveNodeLabels(Long.valueOf(uniqueId));
        }
        catch (Exception e) {
            LOGGER.warn("Save backlight labels failed.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @EventListener(value={LabelsChangedEvent.class})
    public void labelsChangedEvent(LabelsChangedEvent labelsChangedEvent) {
        LOGGER.info("The labels have changed, node: {}", (Object)labelsChangedEvent);
        if (this.backlightPortListPanel != null) {
            SwingUtilities.invokeLater(() -> this.backlightPortListPanel.refreshView());
        }
    }
}

