/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.model;

import java.util.function.IntConsumer;
import org.bidib.jbidibc.messages.enums.IoBehaviourSwitchEnum;
import org.bidib.jbidibc.messages.enums.LcOutputType;
import org.bidib.jbidibc.messages.enums.LoadTypeEnum;
import org.bidib.jbidibc.messages.enums.PortConfigKeys;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.utils.PortUtils;
import org.bidib.wizard.client.common.model.SimpleHierarchicalPortTableModel;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.SwitchPort;
import org.bidib.wizard.model.status.BidibStatus;
import org.bidib.wizard.model.status.SwitchPortStatus;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.listener.SwitchPortModelListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchPortTableModel
extends SimpleHierarchicalPortTableModel<SwitchPortStatus, SwitchPort, SwitchPortModelListener> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SwitchPortTableModel.class);
    public static final int COLUMN_LABEL = 0;
    public static final int COLUMN_IO_BEHAVIOUR = 1;
    public static final int COLUMN_SWITCH_OFF_TIME = 2;
    public static final int COLUMN_LOAD_TYPE = 3;
    public static final int COLUMN_PORT_IDENTIFIER = 4;
    public static final int COLUMN_STATUS = 5;
    public static final int COLUMN_TEST = 6;
    public static final int COLUMN_PORT_INSTANCE = 7;

    public SwitchPortTableModel(MainModel model) {
    }

    public int getColumnPortInstance() {
        return 7;
    }

    protected void initialize() {
        this.columnNames = new String[]{Resources.getString(this.getClass(), (String)"label"), Resources.getString(this.getClass(), (String)"ioBehaviour"), Resources.getString(this.getClass(), (String)"switchOffTime"), Resources.getString(this.getClass(), (String)"loadType"), Resources.getString(this.getClass(), (String)"portIdentifier"), Resources.getString(this.getClass(), (String)"status"), Resources.getString(this.getClass(), (String)"test"), null};
    }

    public void addRow(SwitchPort port) {
        if (port != null) {
            Object[] rowData = new Object[this.columnNames.length];
            rowData[0] = port.getLabel();
            rowData[1] = port.getOutputBehaviour();
            rowData[2] = port.getSwitchOffTime();
            rowData[3] = port.getLoadType();
            rowData[4] = port.getPortIdentifier();
            rowData[5] = port.getStatus();
            SwitchPortStatus oppositeStatus = (SwitchPortStatus)PortUtils.getOppositeStatus((BidibStatus)((SwitchPortStatus)port.getStatus()));
            rowData[6] = oppositeStatus;
            rowData[7] = port;
            this.addRow(rowData);
        }
    }

    public boolean isCellEditable(int row, int column) {
        boolean isEditable = false;
        SwitchPort switchPort = (SwitchPort)this.getValueAt(row, 7);
        switch (column) {
            case 6: {
                if (Port.getConfiguredPortType((Port)switchPort) != LcOutputType.SWITCHPORT) break;
                isEditable = true;
                break;
            }
        }
        return isEditable;
    }

    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 4: 
            case 7: {
                return Object.class;
            }
            case 6: {
                return Object.class;
            }
            case 1: {
                return IoBehaviourSwitchEnum.class;
            }
            case 3: {
                return LoadTypeEnum.class;
            }
        }
        return Object.class;
    }

    public void setValueAt(Object value, int row, int column) {
        SwitchPort port = (SwitchPort)this.getValueAt(row, 7);
        switch (column) {
            case 0: {
                port.setLabel((String)value);
                super.setValueAt((Object)port.toString(), row, column);
                this.fireLabelChanged((Port)port, port.getLabel());
                break;
            }
            case 1: {
                IoBehaviourSwitchEnum ioBehaviour = (IoBehaviourSwitchEnum)value;
                if (ioBehaviour != port.getOutputBehaviour()) {
                    port.setOutputBehaviour(ioBehaviour);
                    super.setValueAt(value, row, column);
                    this.fireConfigValuesChanged(port, new PortConfigKeys[]{PortConfigKeys.BIDIB_PCFG_SWITCH_CTRL});
                    break;
                }
                LOGGER.debug("The IOBehaviour has not been changed.");
                break;
            }
            case 2: {
                int switchOffTime = (Integer)value;
                if (port.getSwitchOffTime() != switchOffTime) {
                    port.setSwitchOffTime(Integer.valueOf(switchOffTime));
                    super.setValueAt(value, row, column);
                    this.fireConfigValuesChanged(port, new PortConfigKeys[]{PortConfigKeys.BIDIB_PCFG_TICKS});
                    break;
                }
                LOGGER.debug("The switchOff time has not been changed.");
                break;
            }
            case 3: {
                LoadTypeEnum loadType = (LoadTypeEnum)value;
                if (loadType != port.getLoadType()) {
                    port.setLoadType(loadType);
                    super.setValueAt(value, row, column);
                    this.fireConfigValuesChanged(port, new PortConfigKeys[]{PortConfigKeys.BIDIB_PCFG_LOAD_TYPE});
                    break;
                }
                LOGGER.debug("The load type has not been changed.");
                break;
            }
            case 5: {
                port.setStatus((BidibStatus)((SwitchPortStatus)value));
                super.setValueAt(value, row, column);
                break;
            }
            case 6: {
                LOGGER.info("Status of switch port is updated: {}, port: {}", value, (Object)port);
                SwitchPortStatus portStatus = (SwitchPortStatus)value;
                LOGGER.info("Set the test port status: {}", (Object)portStatus);
                super.setValueAt((Object)portStatus, row, column);
                SwitchPort switchPort = new SwitchPort();
                switchPort.setId(port.getId());
                switchPort.setStatus((BidibStatus)portStatus);
                this.fireTestButtonPressed(switchPort);
                break;
            }
            default: {
                super.setValueAt(value, row, column);
            }
        }
    }

    public Object getValueAt(int row, int column) {
        SwitchPort port = (SwitchPort)super.getValueAt(row, 7);
        switch (column) {
            case 0: 
            case 4: {
                column = 7;
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                return port.getLoadType();
            }
            case 2: {
                return port.getSwitchOffTime();
            }
            case 5: {
                return port.getStatus();
            }
        }
        return super.getValueAt(row, column);
    }

    public void notifyPortStatusChanged(SwitchPort port) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            if (!port.equals(this.getValueAt(row, 7))) continue;
            LOGGER.info("The port state has changed: {}", (Object)port.getStatus());
            super.setValueAt((Object)port.getStatus(), row, 5);
            SwitchPortStatus oppositeStatus = (SwitchPortStatus)PortUtils.getOppositeStatus((BidibStatus)((SwitchPortStatus)port.getStatus()));
            LOGGER.info("Update port status: {}, oppositeStatus: {}", (Object)port.getStatus(), (Object)oppositeStatus);
            super.setValueAt((Object)oppositeStatus, row, 6);
            break;
        }
    }

    public void notifyPortConfigChanged(SwitchPort port) {
    }

    public void notifyPortLabelChanged(SwitchPort port) {
        LOGGER.info("The port label was changed for port: {}", (Object)port);
        for (int row = 0; row < this.getRowCount(); ++row) {
            if (!port.equals(this.getValueAt(row, 7))) continue;
            super.setValueAt((Object)port.toString(), row, 0);
            break;
        }
    }

    public void refreshRow(SwitchPort port, IntConsumer rowConsumer) {
        int row = this.findRow(port);
        rowConsumer.accept(row);
    }

    private int findRow(SwitchPort port) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            SwitchPort current = (SwitchPort)this.getValueAt(row, 7);
            if (!port.equals((Object)current)) continue;
            return row;
        }
        return -1;
    }

    public void updatePortConfig(SwitchPort port) {
        LOGGER.debug("The config of the port has changed: {}", (Object)port.getDebugString());
        this.fireConfigValuesChanged(port, new PortConfigKeys[]{PortConfigKeys.BIDIB_PCFG_TICKS, PortConfigKeys.BIDIB_PCFG_SWITCH_CTRL, PortConfigKeys.BIDIB_PCFG_LOAD_TYPE});
        int row = this.findRow(port);
        if (row > -1) {
            this.setValueAt((Object)port.getLabel(), row, 0);
        }
    }

    private void fireConfigValuesChanged(SwitchPort port, PortConfigKeys ... portConfigKeys) {
        LOGGER.info("The values of the port have changed: {}", (Object)port);
        ((SwitchPortModelListener)this.portListener).configChanged((Port)port, portConfigKeys);
    }

    public void changePortType(LcOutputType portType, SwitchPort port) {
        ((SwitchPortModelListener)this.portListener).changePortType(portType, port);
    }

    protected SwitchPort getRow(int rowIndex) {
        SwitchPort port = (SwitchPort)this.getValueAt(rowIndex, 7);
        return port;
    }

    public void fireTestButtonPressed(SwitchPort port) {
        LOGGER.info("Port status has changed for port: {}", (Object)port);
        ((SwitchPortModelListener)this.portListener).testButtonPressed(port, (SwitchPortStatus)port.getStatus());
    }
}

