/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view;

import com.jidesoft.grid.DefaultExpandableRow;
import com.jidesoft.grid.TreeTableModel;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.ProtocolVersion;
import org.bidib.jbidibc.messages.enums.DetachedState;
import org.bidib.jbidibc.messages.exception.InvalidConfigurationException;
import org.bidib.wizard.api.context.ApplicationContext;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.Accessory;
import org.bidib.wizard.api.model.Flag;
import org.bidib.wizard.api.model.Macro;
import org.bidib.wizard.api.model.MacroRef;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.NodeListProvider;
import org.bidib.wizard.api.service.console.ConsoleService;
import org.bidib.wizard.api.service.node.BoosterService;
import org.bidib.wizard.api.service.node.CommandStationService;
import org.bidib.wizard.api.service.node.SwitchingNodeService;
import org.bidib.wizard.api.utils.XmlLocaleUtils;
import org.bidib.wizard.client.common.view.BidibNodeNameUtils;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeHelper;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeModelRegistry;
import org.bidib.wizard.client.common.view.cvdef.CvDefinitionTreeTableModel;
import org.bidib.wizard.common.context.DefaultApplicationContext;
import org.bidib.wizard.common.labels.WizardLabelFactory;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.view.statusbar.StatusBar;
import org.bidib.wizard.config.AccessoryControllerFactory;
import org.bidib.wizard.config.DccAdvControllerFactory;
import org.bidib.wizard.config.DmxModelerControllerFactory;
import org.bidib.wizard.config.FirmwareControllerFactory;
import org.bidib.wizard.config.LocoControllerFactory;
import org.bidib.wizard.config.LocoTableControllerFactory;
import org.bidib.wizard.config.PomProgrammerControllerFactory;
import org.bidib.wizard.config.PtProgrammerControllerFactory;
import org.bidib.wizard.core.labels.BidibLabelUtils;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.core.service.node.NodeService;
import org.bidib.wizard.dcca.client.controller.DccAdvController;
import org.bidib.wizard.dialog.NodeDetailsDialog;
import org.bidib.wizard.model.ports.BacklightPort;
import org.bidib.wizard.model.ports.GenericPort;
import org.bidib.wizard.model.ports.InputPort;
import org.bidib.wizard.model.ports.LightPort;
import org.bidib.wizard.model.ports.Port;
import org.bidib.wizard.model.ports.ServoPort;
import org.bidib.wizard.model.ports.SwitchPairPort;
import org.bidib.wizard.model.ports.SwitchPort;
import org.bidib.wizard.mvc.accessory.controller.AccessoryController;
import org.bidib.wizard.mvc.accessory.controller.listener.AccessoryControllerListener;
import org.bidib.wizard.mvc.common.view.cvdefinition.CvDefinitionPanelProvider;
import org.bidib.wizard.mvc.common.view.cvdefinition.CvValueUtils;
import org.bidib.wizard.mvc.dmx.controller.DmxModelerController;
import org.bidib.wizard.mvc.features.controller.FeaturesController;
import org.bidib.wizard.mvc.features.controller.listener.FeaturesControllerListener;
import org.bidib.wizard.mvc.firmware.controller.FirmwareController;
import org.bidib.wizard.mvc.firmware.controller.listener.FirmwareControllerListener;
import org.bidib.wizard.mvc.loco.controller.LocoController;
import org.bidib.wizard.mvc.locolist.controller.LocoTableController;
import org.bidib.wizard.mvc.main.controller.MainController;
import org.bidib.wizard.mvc.main.controller.MainControllerInterface;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.MainNodeListActionListener;
import org.bidib.wizard.mvc.main.view.MainView;
import org.bidib.wizard.mvc.main.view.component.BulkSwitchNodeOperationsDialog;
import org.bidib.wizard.mvc.main.view.exchange.NodeExchangeHelper;
import org.bidib.wizard.mvc.main.view.panel.NodeListPanel;
import org.bidib.wizard.mvc.main.view.panel.listener.NodeListActionListener;
import org.bidib.wizard.mvc.pom.controller.PomProgrammerController;
import org.bidib.wizard.mvc.pom.controller.listener.PomProgrammerControllerListener;
import org.bidib.wizard.mvc.pt.controller.PtProgrammerController;
import org.bidib.wizard.mvc.pt.controller.listener.PtProgrammerControllerListener;
import org.bidib.wizard.mvc.pt.view.PtConfirmDialog;
import org.bidib.wizard.utils.NodeUtils;
import org.oxbow.swingbits.dialog.task.TaskDialogs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MainNodeListActionListener
implements NodeListActionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainNodeListActionListener.class);
    private String nodeDescription;
    private final MainView view;
    private final MainModel model;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private CommandStationService commandStationService;
    @Autowired
    private SwitchingNodeService switchingNodeService;
    @Autowired
    private BoosterService boosterService;
    @Autowired
    private LocoControllerFactory locoControllerFactory;
    @Autowired
    private LocoTableControllerFactory locoTableControllerFactory;
    @Autowired
    private FirmwareControllerFactory firmwareControllerFactory;
    @Autowired
    private PtProgrammerControllerFactory ptProgrammerControllerFactory;
    @Autowired
    private PomProgrammerControllerFactory pomProgrammerControllerFactory;
    @Autowired
    private AccessoryControllerFactory accessoryControllerFactory;
    @Autowired
    private DmxModelerControllerFactory dmxModelerControllerFactory;
    @Autowired
    private DccAdvControllerFactory dccAdvControllerFactory;
    @Autowired
    private SettingsService settingsService;
    @Autowired
    private WizardLabelWrapper wizardLabelWrapper;
    @Autowired
    private CvDefinitionTreeModelRegistry cvDefinitionTreeModelRegistry;
    @Autowired
    private ConsoleService consoleService;
    @Autowired
    private StatusBar statusBar;

    public MainNodeListActionListener(MainView view, MainModel model) {
        this.view = view;
        this.model = model;
        this.nodeDescription = Resources.getString(MainController.class, (String)"nodeDescription");
    }

    private void setWaitCursor() {
        this.view.setBusy(true);
    }

    private void setDefaultCursor() {
        this.view.setBusy(false);
    }

    private FileFilter getNodeFilter() {
        FileNameExtensionFilter nodeFilter = new FileNameExtensionFilter(this.nodeDescription, "nodex");
        return nodeFilter;
    }

    public void enableAddressMessages(NodeInterface node) {
        List<Feature> features = Arrays.asList(new Feature(9, node.isAddressMessagesEnabled() != false ? 1 : 0));
        this.nodeService.setFeatures("main", node, features);
    }

    public void enableDccStart(NodeInterface node) {
        List<Feature> features = Arrays.asList(new Feature(65, node.isDccStartEnabled() != false ? 1 : 0));
        this.nodeService.setFeatures("main", node, features);
    }

    public void enableExternalStart(NodeInterface node) {
        List<Feature> features = Arrays.asList(new Feature(64, node.isExternalStartEnabled() != false ? 1 : 0));
        this.nodeService.setFeatures("main", node, features);
    }

    public void enableFeedbackMessages(NodeInterface node) {
        List<Feature> features = Arrays.asList(new Feature(1, node.isFeedbackMessagesEnabled() != false ? 1 : 0));
        this.nodeService.setFeatures("main", node, features);
    }

    public void disableFeedbackMirror(NodeInterface node, boolean disable) {
        this.nodeService.setFeedbackMirrorDisabled("main", node, disable);
    }

    public void enableKeyMessages(NodeInterface node) {
        List<Feature> features = Arrays.asList(new Feature(51, node.isKeyMessagesEnabled() != false ? 1 : 0));
        this.nodeService.setFeatures("main", node, features);
    }

    public void features(NodeInterface node, int x, int y) {
        this.setWaitCursor();
        FeaturesController featuresController = new FeaturesController((JFrame)this.view.getFrame(), node, x, y);
        featuresController.addFeaturesControllerListener((FeaturesControllerListener)new /* Unavailable Anonymous Inner Class!! */);
        featuresController.start();
    }

    public void exportNode(NodeInterface node) {
        LOGGER.info("export node: {}", (Object)node);
        NodeExchangeHelper helper = new NodeExchangeHelper();
        String lang = XmlLocaleUtils.getXmlLocaleVendorCV();
        helper.exportNode(this.view.getFrame(), node, this.settingsService, this.nodeService, this.switchingNodeService, this.wizardLabelWrapper, this.cvDefinitionTreeModelRegistry, this.getNodeFilter(), this.statusBar, lang);
    }

    public void importNode(NodeInterface node) {
        NodeExchangeHelper helper = new NodeExchangeHelper();
        helper.importNode(this.view.getFrame(), node, this.settingsService, this.nodeService, this.switchingNodeService, this.cvDefinitionTreeModelRegistry, this.getNodeFilter(), this.wizardLabelWrapper, this.statusBar, (NodeListActionListener)this);
    }

    public void firmwareUpdate(NodeInterface node) {
        this.setWaitCursor();
        FirmwareController firmwareController = this.firmwareControllerFactory.createFirmwareController(node, (JFrame)this.view.getFrame());
        firmwareController.addFirmwareControllerListener((FirmwareControllerListener)new /* Unavailable Anonymous Inner Class!! */);
        firmwareController.start();
    }

    public void identify(NodeInterface node) {
        this.nodeService.identify("main", node, node.getIdentifyState());
    }

    public void dccAdvView(NodeInterface node) {
        DccAdvController dccAdvController = this.dccAdvControllerFactory.createController(node, this.view.getDesktop());
        dccAdvController.start();
    }

    public void ping(NodeInterface node, byte data) {
        this.nodeService.ping("main", node, data);
    }

    public void enableNode(NodeInterface node) {
        this.nodeService.enable("main", node);
    }

    public void disableNode(NodeInterface node) {
        this.nodeService.disable("main", node);
    }

    public Long readUniqueId(NodeInterface node) {
        return this.nodeService.readUniqueId("main", node);
    }

    public void detachAttachNode(NodeInterface node, boolean detach) {
        try {
            LOGGER.info("detachAttachNode, node: {}, detach: {}", (Object)node, (Object)detach);
            Long uniqueId = this.settingsService.getNetBidibSettings().getNetBidibUniqueId();
            if (detach) {
                this.nodeService.detach("main", node, uniqueId);
                node.setDetachedState(DetachedState.DETACHED);
            } else {
                this.nodeService.attach("main", node, uniqueId);
                node.setDetachedState(DetachedState.ATTACHED);
            }
        }
        catch (RuntimeException ex) {
            String message = ex.getMessage();
            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(null), Resources.getString(MainNodeListActionListener.class, (String)"localLogoffRejected.error.message", (Object[])new Object[]{message}), Resources.getString(MainNodeListActionListener.class, (String)"localLogoffRejected.error.title"), 0);
        }
    }

    public void labelChanged(NodeInterface node, String label) {
        LOGGER.info("The label has changed, node: {}, label: {}", (Object)node, (Object)label);
        int stringSize = node.getNode().getStringSize();
        if (stringSize > 0) {
            String userName = label;
            if (label.length() > stringSize) {
                userName = label.substring(0, stringSize);
                LOGGER.info("Shrinked node string from '{}' to:' {}'", (Object)label, (Object)userName);
            }
            LOGGER.info("Set the new username on node: {}", (Object)userName);
            this.nodeService.setNodeDetails("main", node, userName);
        }
        try {
            NodeLabels nodeLabels = this.getNodeLabels(node);
            BidibLabelUtils.replaceNodeLabel((NodeLabels)nodeLabels, (String)label);
            this.saveLabels(node);
        }
        catch (InvalidConfigurationException ex) {
            LOGGER.warn("Save node labels failed.", (Throwable)ex);
            String labelPath = ex.getReason();
            JOptionPane.showMessageDialog(JOptionPane.getFrameForComponent(null), Resources.getString(NodeExchangeHelper.class, (String)"labelfileerror.message", (Object[])new Object[]{labelPath}), Resources.getString(NodeExchangeHelper.class, (String)"labelfileerror.title"), 0);
        }
    }

    public void loco(NodeInterface node) {
        LOGGER.info("Open the loco controller, node: {}", (Object)node);
        try {
            LocoController locoController = this.locoControllerFactory.createLocoController(node.getCommandStationNode(), (JFrame)this.view.getFrame(), this.model.getNodeProvider());
            locoController.start(null);
        }
        catch (Exception ex) {
            LOGGER.warn("Create loco controller failed.", (Throwable)ex);
        }
    }

    public void dccAccessory(NodeInterface node, int x, int y) {
        AccessoryController accessoryController = this.accessoryControllerFactory.createAccessoryController(node, (JFrame)this.view.getFrame(), new Point(x, y));
        accessoryController.addAccessoryControllerListener((AccessoryControllerListener)new /* Unavailable Anonymous Inner Class!! */);
        accessoryController.start();
    }

    public void locoCv(NodeInterface node, int x, int y) {
        PomProgrammerController pomProgrammerController = this.pomProgrammerControllerFactory.createPomProgrammerController(node.getCommandStationNode(), (JFrame)this.view.getFrame(), new Point(x, y));
        pomProgrammerController.addPomProgrammerControllerListener((PomProgrammerControllerListener)new /* Unavailable Anonymous Inner Class!! */);
        pomProgrammerController.start(this.view.getDesktop(), null);
    }

    public void locoCvPt(NodeInterface node, int x, int y) {
        this.setWaitCursor();
        if (!this.settingsService.getWizardSettings().isPtModeDoNotConfirmSwitch()) {
            PtConfirmDialog ptConfirmDialog = new PtConfirmDialog(node, this.settingsService, new Point(x, y));
            if (2 == ptConfirmDialog.getResult()) {
                LOGGER.info("User cancelled ptConfirmDialog.");
                this.setDefaultCursor();
                return;
            }
        } else {
            LOGGER.info("Switch to PT programming is disabled by user!");
        }
        this.setDefaultCursor();
        PtProgrammerController ptProgrammerController = this.ptProgrammerControllerFactory.createPtProgrammerController(node, (JFrame)this.view.getFrame(), new Point(x, y));
        ptProgrammerController.addPtProgrammerControllerListener((PtProgrammerControllerListener)new /* Unavailable Anonymous Inner Class!! */);
        ptProgrammerController.start(this.view.getDesktop());
    }

    public void nodeDetails(NodeInterface node, int x, int y) {
        new NodeDetailsDialog(node, x, y);
    }

    public void bulkSwitchDialog(NodeInterface node, int x, int y) {
        BulkSwitchNodeOperationsDialog dialog = new BulkSwitchNodeOperationsDialog(this.view.getDesktop(), node, this.nodeService, this.switchingNodeService, this.boosterService, this.settingsService, this.consoleService);
        dialog.showDialog();
    }

    public void saveOnNode(NodeInterface node, Map<String, Object> params) {
        LOGGER.info("Save the configuration to the node: {}", (Object)node);
        if (params == null) {
            params = new HashMap<String, Object>();
            params.put("saveMacros", Boolean.TRUE);
            params.put("saveAccessories", Boolean.TRUE);
            params.put("saveBacklightPorts", Boolean.TRUE);
            params.put("saveLightPorts", Boolean.TRUE);
            params.put("saveServoPorts", Boolean.TRUE);
            params.put("saveSwitchPorts", Boolean.TRUE);
            params.put("saveFeatures", Boolean.FALSE);
            params.put("saveConfigurationVariables", Boolean.FALSE);
        }
        if (params.get("saveFeatures") != null && ((Boolean)params.get("saveFeatures")).booleanValue()) {
            LOGGER.info("Save the features on the node.");
            LinkedList features = node.getNode().getFeatures();
            if (CollectionUtils.isNotEmpty((Collection)features)) {
                features = new LinkedList(features);
                for (Feature feature : features) {
                    try {
                        this.nodeService.setFeatures("main", node, Arrays.asList(feature));
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Write feature to node failed: {}", (Object)feature, (Object)ex);
                        StringBuffer sb = new StringBuffer("Save Feature ").append(feature.getFeatureName()).append(" on node failed, value: ").append(feature.getValue());
                        this.addError(params, sb.toString());
                    }
                }
            } else {
                LOGGER.warn("No features to transfer available.");
            }
        }
        if (params.get("saveConfigurationVariables") != null && ((Boolean)params.get("saveConfigurationVariables")).booleanValue()) {
            LOGGER.info("Save the CVs on the node.");
            ApplicationContext applicationContext = DefaultApplicationContext.getInstance();
            CvDefinitionTreeTableModel treeModel = NodeUtils.getCvDefinitionTreeTableModel((NodeInterface)node, (ApplicationContext)applicationContext);
            if (treeModel != null) {
                boolean hasPendingCVChanges = CvDefinitionTreeHelper.hasPendingChanges((TreeTableModel)treeModel);
                LOGGER.info("Before transfer CV values to node, hasPendingCVChanges: {}", (Object)hasPendingCVChanges);
                6 provider = new /* Unavailable Anonymous Inner Class!! */;
                DefaultExpandableRow root = (DefaultExpandableRow)treeModel.getRoot();
                CvValueUtils.writeCvValues((NodeInterface)node, (DefaultExpandableRow)root, (Map)NodeUtils.getCvNumberToNodeMap((NodeInterface)node, (ApplicationContext)applicationContext), (CvDefinitionPanelProvider)provider);
            }
        }
        if (params.get("saveLightPorts") != null && ((Boolean)params.get("saveLightPorts")).booleanValue()) {
            for (LightPort lightPort : node.getLightPorts()) {
                try {
                    this.switchingNodeService.setPortConfig("main", node.getSwitchingNode(), (Port)lightPort);
                }
                catch (Exception ex) {
                    LOGGER.warn("Save lightport configuration on node failed: {}", (Object)lightPort, (Object)ex);
                    this.addError(params, "Save lightport configuration on node failed: " + lightPort);
                }
            }
        } else {
            LOGGER.info("Don't save lightports.");
        }
        if (params.get("saveBacklightPorts") != null && ((Boolean)params.get("saveBacklightPorts")).booleanValue()) {
            for (BacklightPort backlightPort : node.getBacklightPorts()) {
                try {
                    this.switchingNodeService.setPortConfig("main", node.getSwitchingNode(), (Port)backlightPort);
                }
                catch (Exception ex) {
                    LOGGER.warn("Save backlightport configuration on node failed: {}", (Object)backlightPort, (Object)ex);
                    this.addError(params, "Save backlightport configuration on node failed: " + backlightPort);
                }
            }
        } else {
            LOGGER.info("Don't save backlightports.");
        }
        if (params.get("saveServoPorts") != null && ((Boolean)params.get("saveServoPorts")).booleanValue()) {
            LOGGER.info("Set the servo port configuration on the node.");
            for (ServoPort servoPort : node.getServoPorts()) {
                try {
                    this.switchingNodeService.setPortConfig("main", node.getSwitchingNode(), (Port)servoPort);
                }
                catch (Exception ex) {
                    LOGGER.warn("Save servoport configuration on node failed: {}", (Object)servoPort, (Object)ex);
                    this.addError(params, "Save servoport configuration on node failed: " + servoPort);
                }
            }
        } else {
            LOGGER.info("Don't save servoports.");
        }
        boolean hasSwitchPortConfig = false;
        Feature switchPortConfigAvailable = Feature.findFeature((Collection)node.getNode().getFeatures(), (int)67);
        if (switchPortConfigAvailable != null) {
            boolean bl = hasSwitchPortConfig = switchPortConfigAvailable.getValue() > 0;
        }
        if (hasSwitchPortConfig) {
            if (params.get("saveSwitchPorts") != null && ((Boolean)params.get("saveSwitchPorts")).booleanValue()) {
                LOGGER.info("Set the switch port configuration on the node.");
                if (node != null && node.getNode().isPortFlatModelAvailable() && node.getNode().getProtocolVersion().isHigherThan(ProtocolVersion.VERSION_0_5)) {
                    LOGGER.info("The current node supports the flat port model.");
                    LinkedList genericPorts = new LinkedList();
                    genericPorts.addAll(node.getGenericPorts());
                    for (GenericPort genericPort : genericPorts) {
                        LOGGER.info("Prepare the generic port: {}", (Object)genericPort);
                        Map values = genericPort.getPortConfig();
                        this.switchingNodeService.setPortConfig("main", node.getSwitchingNode(), genericPort, genericPort.getCurrentPortType(), values);
                    }
                } else {
                    LOGGER.info("The current node supports the typed port model.");
                    LinkedList switchPorts = new LinkedList();
                    switchPorts.addAll(node.getSwitchPorts());
                    for (Object switchPort : switchPorts) {
                        try {
                            if (switchPort.isEnabled()) {
                                this.switchingNodeService.setPortConfig("main", node.getSwitchingNode(), (Port)switchPort);
                                continue;
                            }
                            LOGGER.info("The current switchPort is not enabled: {}", switchPort);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Save switchPort configuration on node failed: {}", switchPort, (Object)ex);
                            this.addError(params, "Save switchPort configuration on node failed: " + (SwitchPort)switchPort);
                        }
                    }
                    LinkedList switchPairPorts = new LinkedList();
                    switchPairPorts.addAll(node.getSwitchPairPorts());
                    for (SwitchPairPort switchPairPort : switchPairPorts) {
                        try {
                            if (switchPairPort.isEnabled()) {
                                this.switchingNodeService.setPortConfig("main", node.getSwitchingNode(), (Port)switchPairPort);
                                continue;
                            }
                            LOGGER.info("The current switchPairPort is not enabled: {}", (Object)switchPairPort);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Save switchPairPort configuration on node failed: {}", (Object)switchPairPort, (Object)ex);
                            this.addError(params, "Save switchPairPort configuration on node failed: " + switchPairPort);
                        }
                    }
                    LinkedList inputPorts = new LinkedList();
                    inputPorts.addAll(node.getInputPorts());
                    for (InputPort inputPort : inputPorts) {
                        try {
                            if (inputPort.isEnabled()) {
                                this.switchingNodeService.setPortConfig("main", node.getSwitchingNode(), (Port)inputPort);
                                continue;
                            }
                            LOGGER.info("The current inputPort is not enabled: {}", (Object)inputPort);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Save inputPort configuration on node failed: {}", (Object)inputPort, (Object)ex);
                            this.addError(params, "Save inputPort configuration on node failed: " + inputPort);
                        }
                    }
                }
            } else {
                LOGGER.info("Don't save switchports.");
            }
        } else {
            LOGGER.info("Node does not support switch port configuration.");
        }
        if (node.getNode().getStringSize() > 0) {
            LOGGER.info("Transfer the node strings.");
            String userName = node.getNode().getStoredString(1);
            LOGGER.info("Transfer the node string username: {}", (Object)userName);
            try {
                this.nodeService.setNodeDetails("main", node, userName);
            }
            catch (Exception ex) {
                LOGGER.warn("Save userName on node failed: {}", (Object)userName, (Object)ex);
                this.addError(params, "Save userName on node failed: " + userName);
            }
        } else {
            LOGGER.info("The node does not support store node string values.");
        }
        if (params.get("saveMacros") != null && ((Boolean)params.get("saveMacros")).booleanValue()) {
            LOGGER.info("Save macros on the node.");
            for (Macro macro : this.model.getMacros()) {
                LOGGER.info("Save macro: {}", (Object)macro);
                try {
                    Macro macroClone = Macro.cloneMacro((Macro)macro);
                    this.switchingNodeService.saveMacro("main", node.getSwitchingNode(), macroClone);
                }
                catch (Exception ex) {
                    LOGGER.warn("Save macro on node failed: {}", (Object)macro, (Object)ex);
                    this.addError(params, "Save macro on node failed: " + macro);
                }
            }
        } else {
            LOGGER.info("Don't save macros.");
        }
        if (params.get("saveAccessories") != null && ((Boolean)params.get("saveAccessories")).booleanValue()) {
            LOGGER.info("Save accessories on the node.");
            for (Accessory accessory : this.model.getAccessories()) {
                try {
                    Accessory accessoryClone = Accessory.cloneAccessoryData((Accessory)accessory);
                    this.switchingNodeService.saveAccessory("main", node.getSwitchingNode(), accessoryClone);
                }
                catch (Exception ex) {
                    LOGGER.warn("Save accessory on node failed: {}", (Object)accessory, (Object)ex);
                    this.addError(params, "Save accessory on node failed: " + accessory);
                }
            }
        } else {
            LOGGER.info("Don't save accessories.");
        }
    }

    private void addError(Map<String, Object> params, String message) {
        LinkedList<String> saveErrors = (LinkedList<String>)params.get("saveErrors");
        if (saveErrors == null) {
            saveErrors = new LinkedList<String>();
            params.put("saveErrors", saveErrors);
        }
        saveErrors.add(message);
    }

    public void dmxModeler(NodeInterface node) {
        this.setWaitCursor();
        LOGGER.info("Open the DMX modeler for node: {}", (Object)node);
        try {
            DmxModelerController dmxModelerController = this.dmxModelerControllerFactory.createDmxModelerController(node, (JFrame)this.view.getFrame());
            dmxModelerController.start(this.view.getDesktop(), (NodeListProvider)this.model);
        }
        catch (Exception ex) {
            LOGGER.warn("Open DMX modeler failed.", (Throwable)ex);
            JOptionPane.showMessageDialog((Component)this.view.getFrame(), "Open DMX modeler failed.", "Open DMX modeler", 0);
        }
        finally {
            this.setDefaultCursor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void locoList(NodeInterface node) {
        this.setWaitCursor();
        LOGGER.info("Open the loco table for node: {}", (Object)node);
        try {
            ApplicationContext applicationContext = DefaultApplicationContext.getInstance();
            MainControllerInterface mainController = (MainControllerInterface)applicationContext.get("mainController", MainControllerInterface.class);
            LocoTableController locoTableController = (LocoTableController)applicationContext.get("locoTableController", LocoTableController.class);
            if (locoTableController == null) {
                LOGGER.info("Create new locoTableController instance and register in context.");
                locoTableController = this.locoTableControllerFactory.createLocoTableController(node, (JFrame)this.view.getFrame());
                applicationContext.register("locoTableController", (Object)locoTableController);
            }
            locoTableController.start(this.view.getDesktop(), mainController);
            locoTableController.setSelectedNode(node);
        }
        catch (Exception ex) {
            LOGGER.warn("Open loco table failed.", (Throwable)ex);
            JOptionPane.showMessageDialog((Component)this.view.getFrame(), "Open loco table failed.", "Open loco table", 0);
        }
        finally {
            this.setDefaultCursor();
        }
    }

    public void reset(NodeInterface node) {
        LOGGER.info("Reset the node: {}", (Object)node);
        this.nodeService.reset("main", node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateDocumentation(NodeInterface node) {
        if (node != null) {
            try {
                this.setWaitCursor();
                LOGGER.info("Generate documentation for node: {}", (Object)node);
                String bidibNodeFilesDescription = Resources.getString(NodeListPanel.class, (String)"bidibNodeFilesDescription");
                FileNameExtensionFilter bidibNodesFilter = new FileNameExtensionFilter(bidibNodeFilesDescription, "xlsx");
                String defaultFileName = node.toString() + ".xlsx";
                if (StringUtils.isNotBlank((CharSequence)node.getNode().getStoredString(1))) {
                    defaultFileName = node.getNode().getStoredString(1) + ".xlsx";
                }
                String storedWorkingDirectory = null;
                7 dialog = new /* Unavailable Anonymous Inner Class!! */;
                dialog.showDialog();
            }
            catch (Exception ex) {
                LOGGER.warn("Generate documentation failed.", (Throwable)ex);
            }
            finally {
                this.setDefaultCursor();
            }
        }
    }

    public void deleteNodeLabels(NodeInterface node) {
        if (node != null) {
            NodeLabels nodeLabels = this.getNodeLabels(node);
            String label = BidibNodeNameUtils.prepareLabel((NodeInterface)node, (NodeLabels)nodeLabels, (boolean)false, (boolean)false).getNodeLabel();
            boolean delete = TaskDialogs.ask((Window)JOptionPane.getFrameForComponent((Component)this.view.getFrame()), (String)Resources.getString(MainNodeListActionListener.class, (String)"deleteLabels"), (String)Resources.getString(MainNodeListActionListener.class, (String)"deleteLabelsOfNode", (Object[])new Object[]{label}));
            if (delete) {
                this.wizardLabelWrapper.deleteNodeLabels(Long.valueOf(node.getUniqueId()));
                for (Accessory accessory : node.getAccessories()) {
                    accessory.setLabel(null);
                    for (MacroRef aspect : accessory.getAspects()) {
                        aspect.setLabel(null);
                    }
                }
                for (Macro macro : node.getMacros()) {
                    macro.setLabel(null);
                }
                for (Flag flag : node.getFlags()) {
                    flag.setLabel(null);
                }
                for (Port port : node.getPorts()) {
                    port.setLabel(null);
                }
                node.setLabel(null);
            }
        }
    }

    private NodeLabels getNodeLabels(NodeInterface node) {
        WizardLabelFactory wizardLabelFactory = this.wizardLabelWrapper.getWizardLabelFactory();
        NodeLabels nodeLabels = wizardLabelFactory.loadLabels(Long.valueOf(node.getUniqueId()), new String[0]);
        return nodeLabels;
    }

    private void saveLabels(NodeInterface node) {
        try {
            long uniqueId = node.getUniqueId();
            this.wizardLabelWrapper.saveNodeLabels(Long.valueOf(uniqueId));
        }
        catch (Exception e) {
            LOGGER.warn("Save accessory labels failed.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void reloadNode(NodeInterface node) {
        LOGGER.info("Reload the node configuration: {}", (Object)node);
        this.nodeService.reloadNode("main", node);
    }
}

