/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.component;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.bidib.wizard.mvc.main.view.component.BusyFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBusyFrame
extends JFrame
implements BusyFrame {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBusyFrame.class);
    protected JPanel glassPane;
    private final Cursor waitCursor = Cursor.getPredefinedCursor(3);
    private final Cursor defaultCursor = Cursor.getDefaultCursor();

    public DefaultBusyFrame() {
        this.initBusyJFrame();
    }

    protected void initBusyJFrame() {
        this.glassPane = new /* Unavailable Anonymous Inner Class!! */;
        this.glassPane.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.glassPane.addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.glassPane.setOpaque(false);
        this.setGlassPane((Component)this.glassPane);
    }

    public boolean setBusy(boolean busy) {
        if (busy) {
            LOGGER.debug("Set wait cursor");
            if (this.waitCursor.equals(this.getCursor())) {
                return false;
            }
            this.setCursor(this.waitCursor);
            this.glassPane.setVisible(true);
            this.glassPane.requestFocus();
            this.glassPane.setCursor(this.waitCursor);
        } else {
            LOGGER.debug("Set default cursor");
            if (this.defaultCursor.equals(this.getCursor())) {
                return false;
            }
            this.glassPane.setCursor(this.defaultCursor);
            this.glassPane.setVisible(false);
            this.requestFocus();
            this.setCursor(this.defaultCursor);
        }
        return true;
    }

    public static void setWaitCursor(Component component) {
        DefaultBusyFrame busyFrame = null;
        Frame frame = JOptionPane.getFrameForComponent(component);
        if (frame instanceof DefaultBusyFrame) {
            busyFrame = (DefaultBusyFrame)frame;
        }
        if (busyFrame != null) {
            busyFrame.setBusy(true);
        }
    }

    public static void setDefaultCursor(Component component) {
        DefaultBusyFrame busyFrame = null;
        Frame frame = JOptionPane.getFrameForComponent(component);
        if (frame instanceof DefaultBusyFrame) {
            busyFrame = (DefaultBusyFrame)frame;
        }
        if (busyFrame != null) {
            busyFrame.setBusy(false);
        }
    }
}

