/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.schema.bidiblabels.NodeLabels;
import org.bidib.jbidibc.messages.ProtocolVersion;
import org.bidib.jbidibc.messages.enums.BoosterControl;
import org.bidib.jbidibc.messages.enums.DetachedState;
import org.bidib.jbidibc.messages.enums.IdentifyState;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.messages.utils.ProductUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.client.common.view.BidibNodeNameUtils;
import org.bidib.wizard.common.labels.WizardLabelWrapper;
import org.bidib.wizard.common.utils.ImageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BidibNodeRenderer
extends JPanel
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(BidibNodeRenderer.class);
    private final WizardLabelWrapper wizardLabelWrapper;
    private JLabel mainIconLabel;
    private JLabel additionalIconLabel;
    private JLabel valueLabel;
    private final Icon bidibLeafIcon;
    private final Icon bidibIdentifyIcon;
    private final Icon bidibNodeIcon;
    private final Icon bidibErrorIcon;
    private final Icon bidibRestartIcon;
    private final Icon bidibLeafWarnIcon;
    private final Icon bidibNodeWarnIcon;
    private final Icon bidibDetachedIcon;
    private final Icon bidibNodeConfigPendingIcon;
    private boolean alwaysShowProductNameInTree;
    private String messageUnsupportedProtocol;
    protected Color textSelectionColor;
    protected Color textNonSelectionColor;
    protected Color backgroundSelectionColor;
    protected Color backgroundNonSelectionColor;
    protected Color borderSelectionColor;
    private Map<BoosterControl, ImageIcon> boosterControlIcons;
    private final Icon multiBaseMasterIcon;
    private final Icon multiBaseSlaveIcon;
    private final String multiBaseMasterTooltip;
    private final String multiBaseSlaveTooltip;
    private boolean inited;
    private Map<BoosterControl, String> boosterControlToolTips;

    public BidibNodeRenderer(WizardLabelWrapper wizardLabelWrapper, Icon leafIcon, Icon nodeIcon, Icon identifyIcon, Icon errorIcon, Icon restartPendingIcon, Icon leafWarnIcon, Icon nodeWarnIcon, Icon detachedIcon, Icon nodeConfigPendingIcon, String messageUnsupportedProtocol) {
        this.wizardLabelWrapper = wizardLabelWrapper;
        this.bidibLeafIcon = leafIcon;
        this.bidibNodeIcon = nodeIcon;
        this.bidibIdentifyIcon = identifyIcon;
        this.bidibErrorIcon = errorIcon;
        this.bidibRestartIcon = restartPendingIcon;
        this.bidibLeafWarnIcon = leafWarnIcon;
        this.bidibNodeWarnIcon = nodeWarnIcon;
        this.bidibDetachedIcon = detachedIcon;
        this.bidibNodeConfigPendingIcon = nodeConfigPendingIcon;
        this.messageUnsupportedProtocol = messageUnsupportedProtocol;
        this.boosterControlIcons = new LinkedHashMap();
        this.boosterControlIcons.put(BoosterControl.CONNECT, ImageUtils.createImageIcon(BidibNodeRenderer.class, (String)UIManager.getString("BoosterControl.connect.icon.name"), (int)16, (int)16));
        this.boosterControlIcons.put(BoosterControl.LOCAL, ImageUtils.createImageIcon(BidibNodeRenderer.class, (String)UIManager.getString("BoosterControl.local.icon.name"), (int)16, (int)16));
        this.boosterControlIcons.put(BoosterControl.REMOTE, ImageUtils.createImageIcon(BidibNodeRenderer.class, (String)UIManager.getString("BoosterControl.remote.icon.name"), (int)16, (int)16));
        this.boosterControlToolTips = new LinkedHashMap();
        this.boosterControlToolTips.put(BoosterControl.CONNECT, Resources.getString(BoosterControl.class, (String)"connect.tooltip"));
        this.boosterControlToolTips.put(BoosterControl.LOCAL, Resources.getString(BoosterControl.class, (String)"local.tooltip"));
        this.boosterControlToolTips.put(BoosterControl.REMOTE, Resources.getString(BoosterControl.class, (String)"remote.tooltip"));
        this.multiBaseMasterIcon = ImageUtils.createImageIcon(BidibNodeRenderer.class, (String)"/icons/rfbase/speedgauge_16x16.png", (int)16, (int)16);
        this.multiBaseSlaveIcon = ImageUtils.createImageIcon(BidibNodeRenderer.class, (String)"/icons/rfbase/rfbase_16x16.png", (int)16, (int)16);
        this.multiBaseMasterTooltip = Resources.getString(BidibNodeRenderer.class, (String)"rfbasis.tooltip.master");
        this.multiBaseSlaveTooltip = Resources.getString(BidibNodeRenderer.class, (String)"rfbasis.tooltip.slave");
        this.setLayout((LayoutManager)new BoxLayout((Container)this, 2));
        this.setOpaque(false);
        this.mainIconLabel = new JLabel(new ImageIcon());
        this.additionalIconLabel = new JLabel(new ImageIcon());
        this.valueLabel = new JLabel();
        this.valueLabel.setOpaque(true);
        this.valueLabel.setBorder(new EmptyBorder(1, 2, 1, 2));
        this.add((Component)this.mainIconLabel);
        this.add((Component)this.additionalIconLabel);
        this.add(Box.createRigidArea(new Dimension(4, 0)));
        this.add((Component)this.valueLabel);
        this.inited = true;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        Insets margins = UIManager.getInsets("Tree.rendererMargins");
        if (margins != null) {
            this.setBorder((Border)new EmptyBorder(margins.top, margins.left, margins.bottom, margins.right));
        }
        if (!this.inited || this.getTextSelectionColor() instanceof UIResource) {
            this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
        }
        if (!this.inited || this.getTextNonSelectionColor() instanceof UIResource) {
            this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
        }
        if (!this.inited || this.getBackgroundSelectionColor() instanceof UIResource) {
            this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        }
        if (!this.inited || this.getBackgroundNonSelectionColor() instanceof UIResource) {
            this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
        }
        if (!this.inited || this.getBorderSelectionColor() instanceof UIResource) {
            this.setBorderSelectionColor(UIManager.getColor("Tree.selectionBorderColor"));
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        NodeInterface node = (NodeInterface)value;
        boolean leaf = !NodeUtils.hasSubNodesFunctions((long)node.getUniqueId());
        String tooltipText = null;
        if (this.isDetachedNode(node)) {
            this.mainIconLabel.setIcon(this.bidibDetachedIcon);
            tooltipText = "Node is detached";
        } else if (this.isNodeHasError(node)) {
            if (this.isNodeHasRestartPendingError(node)) {
                this.mainIconLabel.setIcon(this.bidibRestartIcon);
            } else {
                this.mainIconLabel.setIcon(this.bidibErrorIcon);
            }
        } else if (this.isIdentifyNode(node)) {
            this.mainIconLabel.setIcon(this.bidibIdentifyIcon);
        } else if (this.isNodeConfigPending(node)) {
            this.mainIconLabel.setIcon(this.bidibNodeConfigPendingIcon);
        } else if (this.isUnsupportedProtocolVersionNode(node)) {
            if (leaf) {
                this.mainIconLabel.setIcon(this.bidibLeafWarnIcon);
            } else {
                this.mainIconLabel.setIcon(this.bidibNodeWarnIcon);
            }
        } else if (this.isUpdateableNode(node)) {
            if (leaf) {
                this.mainIconLabel.setIcon(this.bidibLeafIcon);
            } else {
                this.mainIconLabel.setIcon(this.bidibNodeIcon);
            }
        } else if (leaf) {
            this.mainIconLabel.setIcon(this.bidibLeafIcon);
        } else {
            this.mainIconLabel.setIcon(this.bidibNodeIcon);
        }
        this.prepareLabel(node);
        if (isSelected) {
            this.valueLabel.setBackground(this.getBackgroundSelectionColor());
            this.valueLabel.setForeground(this.getTextSelectionColor());
        } else {
            this.valueLabel.setBackground(this.getBackgroundNonSelectionColor());
            this.valueLabel.setForeground(this.getTextNonSelectionColor());
        }
        this.additionalIconLabel.setIcon(null);
        this.additionalIconLabel.setToolTipText(tooltipText);
        if (node != null) {
            if (NodeUtils.hasBoosterFunctions((long)node.getUniqueId()) && NodeUtils.hasAccessoryFunctions((long)node.getUniqueId())) {
                try {
                    BoosterControl boosterControl = node.getBoosterNode().getBoosterControl();
                    Icon boosterControlIcon = (Icon)this.boosterControlIcons.get(boosterControl);
                    this.additionalIconLabel.setIcon(boosterControlIcon);
                    this.additionalIconLabel.setToolTipText((String)this.boosterControlToolTips.get(boosterControl));
                }
                catch (Exception ex) {
                    LOGGER.warn("Set the booster source control icon failed.", (Throwable)ex);
                }
            } else if (ProductUtils.isRFBasisNode((long)node.getUniqueId()) && node.getBaseNumber() > 0) {
                if (node.getBaseNumber() == 1) {
                    this.additionalIconLabel.setIcon(this.multiBaseMasterIcon);
                    this.additionalIconLabel.setToolTipText(this.multiBaseMasterTooltip);
                } else {
                    this.additionalIconLabel.setIcon(this.multiBaseSlaveIcon);
                    this.additionalIconLabel.setToolTipText(this.multiBaseSlaveTooltip);
                }
            }
        }
        return this;
    }

    private boolean isNodeConfigPending(NodeInterface node) {
        if (node != null) {
            return !node.isInitialLoadFinished();
        }
        return false;
    }

    protected void prepareLabel(NodeInterface node) {
        NodeLabels nodeLabels = this.wizardLabelWrapper.loadLabels(Long.valueOf(node.getUniqueId()));
        BidibNodeNameUtils.NodeLabelData labelData = BidibNodeNameUtils.prepareLabel((NodeInterface)node, (NodeLabels)nodeLabels, (boolean)this.alwaysShowProductNameInTree, (boolean)true);
        this.valueLabel.setText(labelData.getNodeLabel());
        if (this.isUnsupportedProtocolVersionNode(node)) {
            this.setToolTipText(this.messageUnsupportedProtocol);
        } else if (this.isNodeHasError(node)) {
            String errorReason = BidibNodeNameUtils.getErrorReason((NodeInterface)node);
            this.setToolTipText(errorReason);
        } else {
            this.setToolTipText(labelData.getNodeToolTipText());
        }
    }

    protected boolean isNodeHasError(NodeInterface node) {
        if (node != null) {
            return node.isNodeHasError();
        }
        return false;
    }

    protected boolean isNodeHasRestartPendingError(NodeInterface node) {
        if (node != null) {
            return node.isNodeHasRestartPendingError();
        }
        return false;
    }

    protected boolean isUpdateableNode(NodeInterface node) {
        if (node != null) {
            return node.isUpdatable();
        }
        return false;
    }

    protected boolean isIdentifyNode(NodeInterface node) {
        return node != null && IdentifyState.START.equals((Object)node.getIdentifyState());
    }

    protected boolean isDetachedNode(NodeInterface node) {
        return node != null && node.getDetachedState() == DetachedState.DETACHED;
    }

    protected boolean isUnsupportedProtocolVersionNode(NodeInterface node) {
        return node != null && ProtocolVersion.isUnsupportedProtocolVersion((ProtocolVersion)node.getNode().getProtocolVersion());
    }

    public void setAlwaysShowProductNameInTree(boolean alwaysShowProductNameInTree) {
        this.alwaysShowProductNameInTree = alwaysShowProductNameInTree;
    }

    public void setTextSelectionColor(Color newColor) {
        this.textSelectionColor = newColor;
    }

    public Color getTextSelectionColor() {
        return this.textSelectionColor;
    }

    public void setTextNonSelectionColor(Color newColor) {
        this.textNonSelectionColor = newColor;
    }

    public Color getTextNonSelectionColor() {
        return this.textNonSelectionColor;
    }

    public void setBackgroundSelectionColor(Color newColor) {
        this.backgroundSelectionColor = newColor;
    }

    public Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    public void setBackgroundNonSelectionColor(Color newColor) {
        this.backgroundNonSelectionColor = newColor;
    }

    public Color getBackgroundNonSelectionColor() {
        return this.backgroundNonSelectionColor;
    }

    public void setBorderSelectionColor(Color newColor) {
        this.borderSelectionColor = newColor;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    @Override
    public String getToolTipText(MouseEvent newEvent) {
        String tip;
        LOGGER.trace("Get the tooltip text, p: {}", (Object)newEvent.getPoint());
        Point p = newEvent.getPoint();
        if (p.x > 16 && p.x < 33 && StringUtils.isNotBlank((CharSequence)(tip = this.additionalIconLabel.getToolTipText()))) {
            return tip;
        }
        return super.getToolTipText(newEvent);
    }
}

