/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.jidesoft.grid.TableColumnChooser;
import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.StyledLabelBuilder;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.commons.collections4.IterableUtils;
import org.bidib.wizard.api.model.Flag;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.listener.FlagListListener;
import org.bidib.wizard.client.common.table.AbstractEmptyTable;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.common.script.node.types.TargetType;
import org.bidib.wizard.mvc.main.controller.FlagPanelController;
import org.bidib.wizard.mvc.main.model.FlagTableModel;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.model.listener.FlagListener;
import org.bidib.wizard.mvc.main.view.panel.FlagListPanel;
import org.bidib.wizard.mvc.main.view.table.FlagEditor;
import org.bidib.wizard.mvc.main.view.table.FlagRenderer;
import org.bidib.wizard.nodescript.script.node.ChangeLabelSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlagListPanel
implements TabPanelProvider,
ChangeLabelSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlagListPanel.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "fill:pref:grow, 5dlu, 200dlu";
    private static final String ENCODED_DIALOG_ROW_SPECS = "fill:200dlu:grow";
    private final MainModel mainModel;
    private final JPanel contentPanel;
    private final AbstractEmptyTable table;
    private final FlagTableModel tableModel;
    private final FlagPanelController flagsPanelController;
    private NodeInterface node;
    private final FlagListListener flagListListener;

    public FlagListPanel(FlagPanelController flagsPanelController, MainModel mainModel) {
        1 panel;
        this.mainModel = mainModel;
        this.flagsPanelController = flagsPanelController;
        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new /* Unavailable Anonymous Inner Class!! */;
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new /* Unavailable Anonymous Inner Class!! */;
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        dialogBuilder.border((Border)Paddings.TABBED_DIALOG);
        this.tableModel = new FlagTableModel(mainModel);
        this.table = new /* Unavailable Anonymous Inner Class!! */;
        this.table.putClientProperty((Object)"terminateEditOnFocusLost", (Object)Boolean.TRUE);
        this.table.adjustRowHeight();
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setSortable(false);
        TableColumn tc = this.table.getColumnModel().getColumn(0);
        tc.setCellRenderer((TableCellRenderer)new FlagRenderer());
        tc.setCellEditor((TableCellEditor)new FlagEditor());
        TableColumnChooser.hideColumn((JTable)this.table, (int)1);
        this.tableModel.addFlagListener((FlagListener)new /* Unavailable Anonymous Inner Class!! */);
        DefaultOverlayable overlayTable = new DefaultOverlayable((JComponent)new JScrollPane((Component)this.table));
        this.tableModel.addTableModelListener((TableModelListener)new /* Unavailable Anonymous Inner Class!! */);
        overlayTable.addOverlayComponent((JComponent)StyledLabelBuilder.createStyledLabel((String)("{" + this.table.getEmptyTableText() + ":f:gray}")));
        dialogBuilder.add((Component)overlayTable).xyw(1, 1, 3);
        this.contentPanel = dialogBuilder.build();
        this.flagListListener = new /* Unavailable Anonymous Inner Class!! */;
    }

    public JPanel getComponent() {
        return this.contentPanel;
    }

    public void changeLabel(TargetType portType) {
        LOGGER.info("Change the label of the flag: {}", (Object)portType);
        int flagNum = portType.getPortNum();
        String label = portType.getLabel();
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            List flags = node.getFlags();
            Flag flag = (Flag)IterableUtils.find((Iterable)flags, object -> object.getId() == flagNum);
            LOGGER.info("Change label of flag: {}", (Object)flag);
            if (flag != null) {
                flag.setLabel(label);
                this.fireFlagLabelChanged(flag.getId());
            }
        }
    }

    private void fireFlagLabelChanged(int flagId) {
        Flag flag = (Flag)this.tableModel.getValueAt(flagId, 1);
        this.flagsPanelController.setFlagLabel(flagId, flag.getLabel());
    }

    public void nodeChanged() {
        LOGGER.debug("The selected node has changed.");
        if (this.node != null) {
            this.node.removeFlagListListener(this.flagListListener);
        }
        this.node = this.mainModel.getSelectedNode();
        if (this.node != null) {
            this.node.addFlagListListener(this.flagListListener);
        }
        this.refreshFlags();
    }

    protected void refreshFlags() {
        LOGGER.debug("refresh the flags.");
        this.tableModel.setRowCount(0);
        NodeInterface node = this.mainModel.getSelectedNode();
        if (node != null) {
            List flags = node.getFlags();
            for (Flag flag : flags) {
                LOGGER.debug("Adding row for flag: {}", (Object)flag);
                this.tableModel.addRow(flag);
            }
        }
    }

    public void refreshView() {
        this.refreshFlags();
    }
}

