/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.mvc.main.view.panel;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.schema.BidibFactory;
import org.bidib.jbidibc.core.schema.DecoderVendorFactory;
import org.bidib.jbidibc.core.schema.bidib.products.ProductType;
import org.bidib.jbidibc.core.schema.bidib2.FeatureCode;
import org.bidib.jbidibc.core.schema.bidib2.common.DocumentationType;
import org.bidib.jbidibc.core.schema.decodervendor.VendorType;
import org.bidib.jbidibc.exchange.bidib.ProductsUtils;
import org.bidib.jbidibc.messages.Feature;
import org.bidib.jbidibc.messages.Node;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.ConversionUtils;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.wizard.api.LookupService;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.utils.XmlLocaleUtils;
import org.bidib.wizard.client.common.component.HtmlColorPane;
import org.bidib.wizard.client.common.view.BidibNodeNameUtils;
import org.bidib.wizard.client.common.view.TabPanelProvider;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.core.service.SettingsService;
import org.bidib.wizard.mvc.main.model.MainModel;
import org.bidib.wizard.mvc.main.view.panel.InfoPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoPanel
implements TabPanelProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfoPanel.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "fill:pref:grow, 5dlu, 200dlu";
    private static final String ENCODED_DIALOG_ROW_SPECS = "fill:200dlu:grow";
    private final MainModel mainModel;
    private final HtmlColorPane infoArea = new HtmlColorPane();
    private final JPanel contentPanel;
    private List<VendorType> vendors;
    private JScrollPane logsPane;
    private final PropertyChangeListener nodeListener;
    private NodeInterface selectedNode;
    private JLabel imageContainer;
    private List<FeatureCode> featureCodes;
    private final SettingsService settingsService;
    private final LookupService lookupService;

    public InfoPanel(MainModel model, SettingsService settingsService, LookupService lookupService) {
        this.mainModel = model;
        this.settingsService = settingsService;
        this.lookupService = lookupService;
        this.nodeListener = new /* Unavailable Anonymous Inner Class!! */;
        this.featureCodes = BidibFactory.getFeatureCodes();
        this.vendors = DecoderVendorFactory.getDecoderVendors();
        FormBuilder dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)new InfoFormPanel());
        dialogBuilder.border((Border)Paddings.TABBED_DIALOG);
        this.infoArea.initialize();
        this.logsPane = new JScrollPane((Component)this.infoArea);
        dialogBuilder.add((Component)this.logsPane).xy(1, 1);
        this.imageContainer = new JLabel();
        this.imageContainer.setPreferredSize(new Dimension(200, 200));
        this.imageContainer.setMaximumSize(new Dimension(200, 200));
        JPanel imagePanel = new JPanel(new BorderLayout());
        imagePanel.setOpaque(false);
        imagePanel.add((Component)this.imageContainer, "North");
        dialogBuilder.add((Component)imagePanel).xy(3, 1);
        JScrollPane scrollContent = new JScrollPane(dialogBuilder.build());
        this.contentPanel = new /* Unavailable Anonymous Inner Class!! */;
        this.contentPanel.add((Component)scrollContent, "Center");
    }

    public JPanel getComponent() {
        return this.contentPanel;
    }

    public void nodeChanged() {
        LOGGER.debug("The selected node has changed.");
        this.updateComponentState();
    }

    private void updateComponentState() {
        NodeInterface node = this.mainModel.getSelectedNode();
        if (this.selectedNode != null && !this.selectedNode.equals(node)) {
            this.selectedNode.getNode().removePropertyChangeListener(this.nodeListener);
        }
        if (node != null) {
            this.selectedNode = node;
            this.selectedNode.getNode().addPropertyChangeListener(this.nodeListener);
            this.updateNodeInfo(node);
        } else {
            this.selectedNode = null;
        }
        this.infoArea.setCaretPosition(0);
    }

    private void updateNodeInfo(NodeInterface node) {
        String productName;
        if (node == null) {
            return;
        }
        Node coreNode = node.getNode();
        LOGGER.info("Update the node info panel for node: {}, coreNode: {}, coreNode identity: {}", new Object[]{node, coreNode, coreNode.getIdentity()});
        this.infoArea.clear();
        long uniqueId = node.getUniqueId();
        int vendorId = NodeUtils.getVendorId((long)node.getUniqueId());
        int productId = NodeUtils.getPid((long)node.getUniqueId(), (int)coreNode.getRelevantPidBits());
        LOGGER.info("Search for vendorId: {} (0x{}), productId: {} (0x{})", new Object[]{vendorId, ByteUtils.intToHex((int)vendorId), productId, ByteUtils.intToHex((int)productId)});
        Optional product = this.lookupService.getProduct(vendorId, productId);
        StringBuilder sb = new StringBuilder();
        StringBuilder description = new StringBuilder();
        String url = null;
        if (product.isPresent()) {
            description.append(((ProductType)product.get()).getName());
            String language = XmlLocaleUtils.getXmlLocale();
            DocumentationType doc = ProductsUtils.getDocumentationOfLanguage((ProductType)((ProductType)product.get()), (String)language);
            if (doc != null) {
                if (StringUtils.isNotBlank((CharSequence)doc.getDescription())) {
                    description.append(" - ").append(doc.getDescription());
                }
                url = doc.getUrl();
            }
        } else {
            LOGGER.info("No products available to get the description for node: {}", (Object)node);
        }
        if (description.length() == 0) {
            description.append(Resources.getString(this.getClass(), (String)"product-unknown"));
        }
        if (StringUtils.isBlank((CharSequence)(productName = coreNode.getStoredString(0)))) {
            productName = "";
        }
        String lineTerm = this.infoArea.getLineTerm();
        Color foreGround = UIManager.getColor("Text.foreground");
        this.infoArea.append(foreGround, Resources.getString(this.getClass(), (String)"description"));
        this.infoArea.append(foreGround, " : ");
        this.infoArea.append(foreGround, description.toString());
        this.infoArea.append(foreGround, lineTerm);
        sb.append(Resources.getString(this.getClass(), (String)"productname")).append(" : ").append(productName).append(lineTerm);
        sb.append(Resources.getString(this.getClass(), (String)"vendor")).append(" : ").append(DecoderVendorFactory.getDecoderVendorName((List)this.vendors, (int)vendorId)).append(lineTerm);
        sb.append("Homepage ..... : ");
        if (StringUtils.isBlank((CharSequence)url)) {
            sb.append("---");
        } else {
            this.infoArea.append(foreGround, sb.toString());
            sb.setLength(0);
            this.infoArea.appendLink(foreGround, url);
        }
        sb.append(lineTerm);
        sb.append("Unique ID .... : ");
        this.infoArea.append(foreGround, sb.toString());
        this.infoArea.append(Color.RED, ByteUtils.convertUniqueIdToString((byte[])ByteUtils.convertLongToUniqueId((long)uniqueId)));
        this.infoArea.append(foreGround, ", ");
        this.infoArea.append(UIManager.getColor("InfoPanel.uniqueId.formatted.foreground"), ByteUtils.getUniqueIdAsString((long)uniqueId));
        sb.setLength(0);
        sb.append(lineTerm);
        sb.append(Resources.getString(this.getClass(), (String)"username")).append(" : ");
        this.infoArea.append(foreGround, sb.toString());
        this.infoArea.append(Color.GREEN.darker().darker(), BidibNodeNameUtils.getNodeName((NodeInterface)node));
        sb.setLength(0);
        sb.append(lineTerm);
        sb.append(Resources.getString(this.getClass(), (String)"address")).append(" : ").append(NodeUtils.formatAddressLong((byte[])coreNode.getAddr())).append(lineTerm);
        sb.append("Firmware ..... : ").append(coreNode.getSoftwareVersion()).append(lineTerm);
        sb.append(Resources.getString(this.getClass(), (String)"protocol")).append(" : ").append(coreNode.getProtocolVersion()).append(lineTerm);
        LinkedList features = new LinkedList(coreNode.getFeatures());
        sb.append("Feature count &nbsp;: ").append(features.size()).append(lineTerm);
        sb.append("Features ..... : <br/>");
        if (CollectionUtils.isNotEmpty(features)) {
            sb.append("<table>\n").append("<tr><th>ID</th><th>").append(Resources.getString(this.getClass(), (String)"value")).append("</th><th>").append(Resources.getString(this.getClass(), (String)"unit")).append("</th><th>Name</th></tr>");
            Collections.sort(features);
            for (Feature feature : features) {
                sb.append("<tr><td align=\"right\">");
                sb.append(feature.getType()).append("</td><td align=\"right\">").append(feature.getValue()).append("</td>");
                sb.append("<td align=\"right\">").append(StringUtils.leftPad((String)this.getFeatureUnit(feature), (int)10)).append("</td>");
                sb.append("<td>").append(feature.getFeatureName()).append(lineTerm);
                sb.append("</td></tr>");
            }
            sb.append("</table>\n");
        }
        this.infoArea.append(foreGround, sb.toString());
        try {
            LOGGER.debug("Size of container: {}", (Object)this.imageContainer.getSize());
            ImageIcon icon = this.loadImage(vendorId, (long)productId, 200, 200);
            this.imageContainer.setIcon(icon);
        }
        catch (Exception ex) {
            LOGGER.warn("Load image of node failed, vid: {}, pid: {}.", new Object[]{vendorId, productId, ex});
            this.imageContainer.setIcon(null);
        }
        this.infoArea.apply();
        this.infoArea.setCaretPosition(0);
    }

    private String getFeatureUnit(Feature feature) {
        if (feature != null && feature.getFeatureEnum() != null) {
            String featureUnit;
            switch (4.$SwitchMap$org$bidib$jbidibc$messages$enums$FeatureEnum[feature.getFeatureEnum().ordinal()]) {
                case 1: {
                    return String.format("%d mA", ConversionUtils.convertCurrent((int)feature.getValue()));
                }
            }
            FeatureCode featureCode = (FeatureCode)IterableUtils.find((Iterable)this.featureCodes, (Predicate)new /* Unavailable Anonymous Inner Class!! */);
            if (featureCode != null && StringUtils.isNotEmpty((CharSequence)(featureUnit = featureCode.getUnit()))) {
                return featureUnit;
            }
        }
        return " ";
    }

    private ImageIcon loadImage(int vendorId, long productId, int width, int height) {
        String labelPath = this.settingsService.getMiscSettings().getBidibConfigDir();
        String searchPathUser = "/data/images";
        File fileUser = new File(labelPath, searchPathUser);
        searchPathUser = fileUser.getPath();
        ImageIcon icon = null;
        File imageFile = new File(fileUser, "bidib-" + vendorId + "-" + productId + ".png");
        if (imageFile.exists()) {
            icon = ImageUtils.loadImageIcon((File)imageFile, (int)width, (int)height);
        }
        if (icon == null) {
            icon = ImageUtils.loadImageIcon(this.getClass(), (String)("/images/bidib-" + vendorId + "-" + productId + ".png"), (int)width, (int)height);
        }
        return icon;
    }
}

